package io.transwarp.common.bean.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigBean {

	private final String servicename;
	private final Map<String, Map<String, String>> fileValues;
	
	public ConfigBean(final String servicename) {
		this.servicename = servicename;
		this.fileValues = new ConcurrentHashMap<String, Map<String, String>>();
	}

	public String getServiceName() {
		return this.servicename;
	}
	
	public void addConfigFile(final String ipAddress,
			final String filename, 
			final Map<String, String> configFile) {
		this.fileValues.put(String.format("%s|%s", ipAddress, filename), configFile);
	}
	
	public Map<String, String> getConfigFile(final String ipAddress, final String filename) {
		return this.fileValues.get(String.format("%s|%s", ipAddress, filename));
	}
	
	public Map<String, Map<String, String>> getConfigFiles(final String filename) {
		Map<String, Map<String, String>> files = new HashMap<String, Map<String, String>>();
		for (Entry<String, Map<String, String>> entry : fileValues.entrySet()) {
			String fileLabel = entry.getKey();
			Map<String, String> fileValue = entry.getValue();
			String[] items = fileLabel.split("\\|");
			if (items[1].equals(filename)) {
				files.put(items[0], fileValue);
			}
		}
		return files;
	}
}
