package io.transwarp.common.bean.service;

import java.util.ArrayList;
import java.util.List;

public class KafkaTopicBean {

	private String topic;
	private String replicationFactor;
	private String configs;
	private List<KafkaPartitionBean> partitions;
	
	public KafkaTopicBean(final String topic) {
		this.topic = topic;
		this.replicationFactor = "";
		this.configs = "";
		this.partitions = new ArrayList<KafkaPartitionBean>();
	}
	
	public void setTopic(Object topic) {
		this.topic = topic == null ? "" : topic.toString();
	}
	
	public void setReplicationFactor(Object replicationFactor) {
		this.replicationFactor = replicationFactor == null ? "" : replicationFactor.toString();
	}
	
	public void setConfigs(Object configs) {
		this.configs = configs == null ? "" : configs.toString();
	}
	
	public void addPartition(KafkaPartitionBean partition) {
		this.partitions.add(partition);
	}

	public String getTopic() {
		return topic;
	}

	public String getReplicationFactor() {
		return replicationFactor;
	}

	public String getConfigs() {
		return configs;
	}

	public List<KafkaPartitionBean> getPartitions() {
		return partitions;
	}
	
	
}
