package io.transwarp.common.bean.service;

import io.transwarp.common.bean.node.NodeBean;
import net.sf.json.JSONObject;

public class RoleBean {

	private String roleId;
	private String name;
	private String roleType;
	private String status;
	private String health;
	private NodeBean node;
	private String resource;
	
	public RoleBean() {
		this("{}");
	}
	
	public RoleBean(final String json) {
		this(JSONObject.fromObject(json));
	}
	
	public RoleBean(final JSONObject json) {
		this.setRoleId(json.get("id"));
		this.setName(json.get("name"));
		this.setRoleType(json.get("roleType"));
		this.setStatus(json.get("status"));
		this.setHealth(json.get("health"));
		Object nodeJson = json.get("node");
		this.setNode(new NodeBean(nodeJson == null ? "{}" : nodeJson.toString()));
		this.setResource("");
	}
	
	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();
		buffer.append("role name : ").append(this.name)
			.append("\nroleId : ").append(this.roleId)
			.append("\nroleType : ").append(this.roleType)
			.append("\nstatus : ").append(this.status)
			.append("\nhealth : ").append(this.health)
			.append("\nresource : ").append(this.resource)
			.append("\nnode : ").append(this.node.toString());
		return buffer.toString();
	}
	
	public void setRoleId(Object roleId) {
		this.roleId = roleId == null ? "" : roleId.toString();
	}
	
	public void setName(Object name) {
		this.name = name == null ? "" : name.toString();
	}
	
	public void setRoleType(Object roleType) {
		this.roleType = roleType == null ? "" : roleType.toString();
	}
	
	public void setStatus(Object status) {
		this.status = status == null ? "" : status.toString();
	}
	
	public void setHealth(Object health) {
		this.health = health == null ? "" : health.toString();
	}
	
	public void setResource(Object resource) {
		this.resource = resource == null ? "" : resource.toString();
	}
	
	public void setNode(NodeBean node) {
		this.node = node;
	}

	public String getRoleId() {
		return roleId;
	}

	public String getName() {
		return name;
	}

	public String getRoleType() {
		return roleType;
	}

	public String getStatus() {
		return status;
	}

	public String getHealth() {
		return health;
	}

	public NodeBean getNode() {
		return node;
	}

	public String getResource() {
		return resource;
	}
	
	
}
