package io.transwarp.common.bean.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import net.sf.json.JSONObject;

public class ServiceBean {

	private String sid;
	private String id;
	private String name;
	private String dependencies;
	private String status;
	private String installed;
	private String health;
	private String configStatus;
	private String enableKerberos;
	private String type;
	private String clusterId;
	private String clusterName;
	private List<RoleBean> roles;
	private ConfigBean config;
	
	private Map<String, Integer> activeExecutors;
	private Vector<ProcessBean> processes;
	
	public ServiceBean(final String json) {
		this(JSONObject.fromObject(json));
	}
	
	public ServiceBean(final JSONObject json) {
		this.roles = new ArrayList<RoleBean>();
		this.setSid(json.get("sid"));
		this.setId(json.get("id"));
		this.setName(json.get("name"));
		this.setDependencies(json.get("dependencies"));
		this.setStatus(json.get("status"));
		this.setInstalled(json.get("installed"));
		this.setHealth(json.get("health"));
		this.setConfigStatus(json.get("configStatus"));
		this.setEnableKerberos(json.get("enableKerberos"));
		this.setType(json.get("type"));
		this.setClusterId(json.get("clusterId"));
		this.setClusterName(json.get("clusterName"));
		this.config = null;
		this.activeExecutors = new HashMap<String, Integer>();
		this.processes = new Vector<ProcessBean>();
	}
	
	@Override
	public String toString() {
		StringBuffer result = new StringBuffer();
		result.append("name : ").append(this.name)
			.append("\nsid : ").append(this.sid)
			.append("\nid : ").append(this.id)
			.append("\ntype : ").append(this.type)
			.append("\nclusterId : ").append(this.clusterId)
			.append("\nclusterName : ").append(this.clusterName)
			.append("\ndependencies : ").append(this.dependencies)
			.append("\nstatus : ").append(this.status)
			.append("\ninstalled : ").append(this.installed)
			.append("\nhealth : ").append(this.health)
			.append("\nconfigStatus : ").append(this.configStatus)
			.append("\nenableKerberos : ").append(this.enableKerberos);
		for (RoleBean role : roles) {
			result.append("\nroles : ")
				.append("\n\t").append(role.toString());
		}
		return result.toString();
	}
	
	public void addProcessBean(ProcessBean process) {
		this.processes.add(process);
	}

	public void addRole(RoleBean role) {
		this.roles.add(role);
	}
	
	public void addActiveExecutor(final String hostname, final int number) {
		this.activeExecutors.put(hostname, number);
	}
	
	public Vector<ProcessBean> getProcesses() {
		return processes;
	}
	
	public ConfigBean getConfig() {
		return this.config;
	}

	public String getSid() {
		return sid;
	}
	
	public String getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}

	public String getDependencies() {
		return dependencies;
	}

	public String getStatus() {
		return status;
	}

	public String getInstalled() {
		return installed;
	}

	public String getHealth() {
		return health;
	}

	public String getConfigStatus() {
		return configStatus;
	}

	public String getEnableKerberos() {
		return enableKerberos;
	}

	public String getType() {
		return type;
	}

	public String getClusterId() {
		return clusterId;
	}

	public String getClusterName() {
		return clusterName;
	}

	public List<RoleBean> getRoles() {
		return roles;
	}
	
	public Map<String, Integer> getActiveExecutors() {
		return this.activeExecutors;
	}
	
	public Integer getActiveExecutorByHost(final String hostname) {
		return this.activeExecutors.get(hostname);
	}
	
	public void setConfig(ConfigBean config) {
		this.config = config;
	}
	
	public void setSid(Object sid) {
		this.sid = sid == null ? "" : sid.toString();
	}

	public void setId(Object id) {
		this.id = id == null ? "" : id.toString();
	}

	public void setName(Object name) {
		this.name = name == null ? "" : name.toString();
	}

	public void setDependencies(Object dependencies) {
		this.dependencies = dependencies == null ? "" : dependencies.toString();
	}

	public void setStatus(Object status) {
		this.status = status == null ? "" : status.toString();
	}

	public void setInstalled(Object installed) {
		this.installed = installed == null ? "" : installed.toString();
	}

	public void setHealth(Object health) {
		this.health = health == null ? "" : health.toString();
	}

	public void setConfigStatus(Object configStatus) {
		this.configStatus = configStatus == null ? "" : configStatus.toString();
	}

	public void setEnableKerberos(Object enableKerberos) {
		this.enableKerberos = enableKerberos == null ? "" : enableKerberos.toString();
	}

	public void setType(Object type) {
		this.type = type == null ? "" : type.toString();
	}

	public void setClusterId(Object clusterId) {
		this.clusterId = clusterId == null ? "" : clusterId.toString();
	}

	public void setClusterName(Object clusterName) {
		this.clusterName = clusterName == null ? "" : clusterName.toString();
	}
}
