package io.transwarp.common.bean.table;

import io.transwarp.common.util.HdfsConnUtils;

public abstract class AbstractTable {

	private String warning;
	private String database;
	private String tablename;
	private String owner;
	private String tableType;
	private String format;
	private String location;
	
	public AbstractTable() {
	}

	public String getWarning() {
		return warning;
	}

	public String getDatabase() {
		return database;
	}
	
	public String getTablename() {
		return tablename;
	}

	public String getOwner() {
		return owner;
	}

	public String getTableType() {
		return tableType;
	}

	public String getFormat() {
		return format;
	}

	public String getLocation() {
		return HdfsConnUtils.getHdfsPath(location);
	}
	
	public void setWarning(Object warning) {
		this.warning = warning == null ? "null" : warning.toString();
	}

	public void setDatabase(Object database) {
		this.database = database == null ? "" : database.toString();
	}

	public void setTablename(Object tablename) {
		this.tablename = tablename == null ? "" : tablename.toString();
	}

	public void setOwner(Object owner) {
		this.owner = owner == null ? "" : owner.toString();
	}

	public void setTableType(Object tableType) {
		this.tableType = tableType == null ? "" : tableType.toString();
	}

	public void setFormat(Object format) {
		this.format = format == null ? "" : format.toString();
	}

	public void setLocation(Object location) {
		this.location = location == null ? "" : location.toString();
	}
	

}
