package io.transwarp.common.bean.table;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllEsTables {
	private final Map<String, Map<String, EsTableBean>> allTables;
	private final Map<String, String> searchNodeState;
	private final Map<String, String> searchSetting;
	private final Map<String, String> searchThreadPool;
	private final Map<String, List<String[]>> searchIndices;
	
	private final Map<Integer, String> encryptES;
	
	public AllEsTables() {
		allTables = new ConcurrentHashMap<String, Map<String, EsTableBean>>();	
		searchNodeState = new ConcurrentHashMap<String, String>();
		searchSetting = new ConcurrentHashMap<String, String>();
		searchThreadPool = new ConcurrentHashMap<String, String>();
		searchIndices = new ConcurrentHashMap<String, List<String[]>>();
		
		encryptES = new ConcurrentHashMap<Integer, String>();	
	}
	
	public synchronized void addEsTables(final String servicename, final Map<String, EsTableBean> esTables) {
		this.allTables.put(servicename, esTables);
	}
	
	public synchronized void addSearchNodeState(final String servicename, final String nodeState) {
		this.searchNodeState.put(servicename, nodeState);
	}
	
	public synchronized void addSearchSetting(final String servicename, final String setting) {
		this.searchSetting.put(servicename, setting);
	}
	
	public synchronized void addSearchThreadPool(final String servicename, final String threadPool) {
		this.searchThreadPool.put(servicename, threadPool);
	}
	
	public synchronized void addSearchIndices(final String servicename, final List<String[]> indices) {
		this.searchIndices.put(servicename, indices);
	}
	
	public synchronized void addEncryptES(final int tableId, final String tablename) {
		this.encryptES.put(tableId, tablename);
	}
	
	public Map<String, Map<String, EsTableBean>> getAllEsTables() {
		return this.allTables;
	}

	public Map<Integer, String> getEncryptES() {
		return this.encryptES;
	}

	public Map<String, String> getSearchSetting() {
		return searchSetting;
	}

	public Map<String, String> getSearchThreadPool() {
		return searchThreadPool;
	}

	public Map<String, List<String[]>> getSearchIndices() {
		return searchIndices;
	}

	public Map<String, String> getSearchNodeState() {
		return searchNodeState;
	}
}
