package io.transwarp.common.bean.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllHbaseTables {

	private final Map<String, Map<String, HBaseTableBean>> allTables;
	private final Map<Integer, String> encryptHBase;

	private final Map<String, Map<String, String>> regionInTransitions;
	private final Map<String, String> regionStartTime;
	private final Map<String, Map<String, String>> regionParameters;

	public AllHbaseTables() {
		allTables = new ConcurrentHashMap<String, Map<String, HBaseTableBean>>();
		encryptHBase = new ConcurrentHashMap<Integer, String>();
		regionInTransitions = new ConcurrentHashMap<String, Map<String, String>>();
		regionStartTime = new ConcurrentHashMap<String, String>();
		regionParameters = new ConcurrentHashMap<String, Map<String, String>>();
	}
	
	public synchronized String getRegionStartTime(String hostname) {
		String value = this.regionStartTime.get(hostname);
		if (value == null) {
			value = "";
		}
		return value;
	}
	
	public synchronized void addHbaseTables(final String servicename, final Map<String, HBaseTableBean> hbaseTables) {
		this.allTables.put(servicename, hbaseTables);
	}
	
	public synchronized void addRegionInTransitions(final String servicename, final Map<String, String> value) {
		this.regionInTransitions.put(servicename, value);
	}
	
	public synchronized void addRegionParameter(final String servicename, final Map<String, String> value) {
		this.regionParameters.put(servicename, value);
	}
	
	public synchronized void addEncryptHBase(final int tableId, final String tablename) {
		this.encryptHBase.put(tableId, tablename);
	}
	
	public synchronized void addRegionStartTime(final String hostname, final String startTime) {
		this.regionStartTime.put(hostname, startTime);
	}
	
	public Map<String, Map<String, HBaseTableBean>> getAllHBaseTables() {
		return this.allTables;
	}
	
	public Map<String, String> getRegionInTransitions(String servicename) {
		return this.regionInTransitions.get(servicename);
	}
	
	public Map<String, String> getRegionParameter(String servicename) {
		return this.regionParameters.get(servicename);
	}
	
	public Map<Integer, String> getEncryptHBase() {
		return this.encryptHBase;
	}
	
}
