package io.transwarp.common.bean.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllHolodeskTables {

	private final Map<String, Map<String, HolodeskTableBean>> allTables;
	private final Map<Integer, String> encryptHolodesk;
	
	private final Map<String, Map<String, String>> holodeskParameters;
	
	public AllHolodeskTables() {
		allTables = new ConcurrentHashMap<String, Map<String, HolodeskTableBean>>();
		encryptHolodesk = new ConcurrentHashMap<Integer, String>();
		holodeskParameters = new ConcurrentHashMap<String, Map<String, String>>();
	}
	
	public synchronized void addHolodeskTables(final String servicename, final Map<String, HolodeskTableBean> holodeskTables) {
		this.allTables.put(servicename, holodeskTables);
	}
	
	public synchronized void addHolodeskParameter(final String servicename, final Map<String, String> value) {
		this.holodeskParameters.put(servicename, value);
	}

	public synchronized void addEncryptHolodesk(final int tableId, final String tablename) {
		this.encryptHolodesk.put(tableId, tablename);
	}
	
	public Map<String, Map<String, HolodeskTableBean>> getAllHolodeskTables() {
		return this.allTables;
	}
	
	public Map<String, String> getHolodeskParameter(String servicename) {
		return this.holodeskParameters.get(servicename);
	}
	
	public Map<Integer, String> getEncryptHolodesk() {
		return this.encryptHolodesk;
	}
}
