package io.transwarp.common.bean.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllOrcTables {

	private Map<String, Map<String, OrcTableBean>> allTables;
	
	private Map<Integer, String> encryptTables;
	
	public AllOrcTables() {
		this.allTables = new ConcurrentHashMap<String, Map<String, OrcTableBean>>();
		this.encryptTables = new ConcurrentHashMap<Integer, String>();
	}
	
	public synchronized void addOrcTables(final String servicename, final Map<String, OrcTableBean> orcTables) {
		this.allTables.put(servicename, orcTables);
	}
	
	public synchronized void addEncryptOrc(final int tableId, final String tablename) {
		this.encryptTables.put(tableId, tablename);
	}
	
	public Map<String, Map<String, OrcTableBean>> getAllOrcTables() {
		return this.allTables;
	}
	
	public Map<Integer, String> getEncryptOrc() {
		return this.encryptTables;
	}
}
