package io.transwarp.common.bean.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AllTextTables {
	private final Map<String, Map<String, TextTableBean>> allTextTables;
	private final Map<Integer, String> encryptText;

	public AllTextTables() {
		allTextTables = new ConcurrentHashMap<String, Map<String, TextTableBean>>();
		encryptText = new ConcurrentHashMap<Integer, String>();
	}
	
	
	public synchronized void addTextTables(final String servicename, final Map<String, TextTableBean> textTables) {
		this.allTextTables.put(servicename, textTables);
	}
	
	public synchronized void addEncryptText(final int tableId, final String tablename) {
		this.encryptText.put(tableId, tablename);
	}
	
	public Map<String, Map<String, TextTableBean>> getAllTextTables() {
		return this.allTextTables;
	}
	
	public Map<Integer, String> getEncryptText() {
		return this.encryptText;
	}
}
