package io.transwarp.common.bean.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.sf.json.JSONObject;

public class EsTableBean extends AbstractTable {

	private String esTablename;
	private Map<String, JSONObject> primaryShards;
	private List<Map<String, JSONObject>> replicaShardLists;
	
	private JSONObject primaryComparison;
	private List<JSONObject> replicaComparison;
	
	public EsTableBean() {
		primaryShards = new HashMap<String, JSONObject>();
		replicaShardLists = new ArrayList<Map<String, JSONObject>>();
		
		replicaComparison = new ArrayList<JSONObject>();
	}
	
	public void addShardInfo(final JSONObject shardInfo) {
		String shardId = shardInfo.getString("shardId");
		String shardType = shardInfo.getString("prirep");
		if (shardType.equals("p")) {
			primaryShards.put(shardId, shardInfo);
		} else {
			int replicaShardNumber = replicaShardLists.size();
			int iterator = 0;
			while (iterator < replicaShardNumber) {
				Map<String, JSONObject> replicaShard = replicaShardLists.get(iterator);
				if (replicaShard.get(shardId) == null) {
					replicaShard.put(shardId, shardInfo);
					break;
				}
				iterator += 1;
			}
			if (iterator >= replicaShardNumber) {
				Map<String, JSONObject> newReplicaShard = new HashMap<String, JSONObject>();
				newReplicaShard.put(shardId, shardInfo);
				replicaShardLists.add(newReplicaShard);
			}
		}
	}
	
	public void addShardComparison(final String shardType, final JSONObject shardComparison) {
		if (shardType.equals("primary")) {
			this.primaryComparison = shardComparison;
		} else {
			this.replicaComparison.add(shardComparison);
		}
	}
	
	public void setEsTablename(Object esTablename) {
		this.esTablename = esTablename == null ? "" : esTablename.toString();
	}
	
	public String getEsTablename() {
		return this.esTablename;
	}
	
	public Map<String, JSONObject> getPrimaryShard() {
		return this.primaryShards;
	}
	
	public List<Map<String, JSONObject>> getReplicaShardLists() {
		return this.replicaShardLists;
	}
	
	public JSONObject getPrimaryShardComparison() {
		return this.primaryComparison;
	}
	
	public List<JSONObject> getReplicaShardComparison() {
		return this.replicaComparison;
	}
}
