package io.transwarp.common.bean.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HBaseTableBean extends AbstractTable {

	private String hbaseTablename;
	private List<String> families;
	private Map<String, Long> regionSizes;
	private Map<String, List<String>> regionDistribution;
	private Long totalRegionSize;
	
	private Map<String, String> regionComparisons;
	
	public HBaseTableBean() {
		families = new ArrayList<String>();
		regionSizes = new HashMap<String, Long>();
		regionDistribution = new HashMap<String, List<String>>();
		regionComparisons = new HashMap<String, String>();
		totalRegionSize = 0L;
	}
	
	public void addRegionDistribution(final String hostname,
			final String regionName) {
		List<String> distributionOnNode = regionDistribution.get(hostname);
		if (distributionOnNode == null) {
			distributionOnNode = new ArrayList<String>();
			regionDistribution.put(hostname, distributionOnNode);
		}
		distributionOnNode.add(regionName);
	}
	
	public void addFamily(Object family) {
		if (family != null) {
			this.families.add(family.toString());
		}
	}
	
	public void addRegionComparison(final String hostname, final String regionComparison) {
		this.regionComparisons.put(hostname, regionComparison);
	}
	
	public void addRegion(final String regionName, final Long regionSize) {
		this.regionSizes.put(regionName, regionSize);
		this.totalRegionSize += regionSize;
	}
	
	public void setHBaseTablename(Object hbaseTablename) {
		this.hbaseTablename = hbaseTablename == null ? "" : hbaseTablename.toString();
	}
	
	public String getHbaseTablename() {
		return this.hbaseTablename;
	}
	
	public int getTotalRegionNumber() {
		return this.regionSizes.size();
	}
	
	public List<String> getFamilies() {
		return this.families;
	}
	
	public Map<String, Long> getRegionSizes() {
		return this.regionSizes;
	}
	
	public Map<String, List<String>> getRegionDistribution() {
		return this.regionDistribution;
	}
	
	public Long getTotalRegionSize() {
		return this.totalRegionSize;
	}
	
	public Map<String, String> getRegionComparison() {
		return this.regionComparisons;
	}
}
