package io.transwarp.common.bean.table;

import java.util.HashMap;
import java.util.Map;

public class HolodeskTableBean extends AbstractTable {

	private Map<String, Long> blockSizes;
	private Long totalSize;
	
	public HolodeskTableBean() {
		totalSize = 0L;
		blockSizes = new HashMap<String, Long>();
	}
	
	public void addBlock(final String hostname, final Long blockSize) {
		Long oldBlockSize = this.blockSizes.get(hostname);
		if (oldBlockSize == null) {
			oldBlockSize = 0L;
		}
		this.blockSizes.put(hostname, oldBlockSize + blockSize);
		this.totalSize += blockSize;
	}
	
	public Long getTotalSize() {
		return this.totalSize;
	}
	
	public Map<String, Long> getBlockSizes() {
		return this.blockSizes;
	}
}
