package io.transwarp.common.bean.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OrcTableBean extends AbstractTable {

	private String deltaComparison;
	private String bucketComparison;
	private String partitionComparison;
	private Integer smallFileNumber;
	private String smallFilePercent;
	
	private String bucket_column;
	private String bucket_number;
	private String partitionKey;
	private Boolean partitionRange;
	private Boolean transactional;
	
	private List<Long> allFileSizes;
	private List<String> partitionNames;
	private Map<String, Long> fileNameAndSizeMap;
	private Map<String, Set<String>> allPartitionListMap;
	private Map<String, Integer> deltaMenuNumbers;
	
	public OrcTableBean() {
		allFileSizes = new ArrayList<Long>();
		partitionNames = new ArrayList<String>();
		fileNameAndSizeMap = new HashMap<String, Long>();
		deltaMenuNumbers = new HashMap<String, Integer>();
		allPartitionListMap = new HashMap<String, Set<String>>();
		
		deltaComparison = " | |0";
		bucketComparison = " | | |0";
		partitionComparison = " | | |0";
		smallFilePercent = "null";
		smallFileNumber = 0;
		
		bucket_column = "";
		bucket_number = "0";
		partitionKey = "";
		partitionRange = false;
		transactional = false;
	}
	
	public void addDataFile(final String partitionName, 
			final String filename, 
			final Long fileSize) {
		allFileSizes.add(fileSize);
		
		Set<String> partitionFileList = allPartitionListMap.get(partitionName);
		if (partitionFileList == null) {
			partitionFileList = new HashSet<String>();
			allPartitionListMap.put(partitionName, partitionFileList);
		}
		partitionFileList.add(filename);
		String topic = String.format("%s-%s", partitionName, filename);
		Long oldFileSize = fileNameAndSizeMap.get(topic);
		if (oldFileSize == null) {
			oldFileSize = 0L;
		}
		fileNameAndSizeMap.put(topic, oldFileSize + fileSize);
	}
	
	public void addPartition(final Object partitionName) {
		if (partitionName == null) {
			return;
		}
		this.partitionNames.add(partitionName.toString());
	}
	
	public void addDeltaMenu(final String partitionName, final Integer deltaMenuNumber) {
		this.deltaMenuNumbers.put(partitionName, deltaMenuNumber);
	}
	
	public void setBucketColumn(Object bucket_column) {
		this.bucket_column = bucket_column == null ? "" : bucket_column.toString();
	}
	
	public void setBucketNumber(Object bucket_number) {
		this.bucket_number = bucket_number == null ? "0" : bucket_number.toString();
	}
	
	public void setPartitionKey(Object partitionKey) {
		this.partitionKey = partitionKey == null ? "" : partitionKey.toString();
	}
	
	public void setPartitionRange(Object partitionRange) {
		this.partitionRange = partitionRange == null ? false : (partitionRange.toString().equals("true") ? true : false);
	}
	
	public void setTransactional(Object transactional) {
		this.transactional = transactional == null ? false : (transactional.toString().equals("true") ? true : false);
	}
	
	public void setDeltaComparison(Object deltaComparison) {
		this.deltaComparison = deltaComparison == null ? " | |0" : deltaComparison.toString();
	}
	
	public void setBucketComparison(Object bucketComparison) {
		this.bucketComparison = bucketComparison == null ? " | | |0" : bucketComparison.toString();
	}
	
	public void setPartitionComparison(Object partitionComparison) {
		this.partitionComparison = partitionComparison == null ? " | | |0" : partitionComparison.toString();
	}
	
	public void setSmallFileNumber(Object smallFileNumber) {
		this.smallFileNumber = smallFileNumber == null ? 0 : Integer.valueOf(smallFileNumber.toString());
	}
	
	public void setSmallFilePercent(Object smallFilePercent) {
		this.smallFilePercent = smallFilePercent == null ? "0.00 %" : smallFilePercent.toString();
	}
	
	public String getBucketColumn() {
		return this.bucket_column;
	}
	
	public String getBucketNumber() {
		return this.bucket_number;
	}
	
	public String getPartitionKey() {
		return this.partitionKey;
	}
	
	public Boolean isPartitionRange() {
		return this.partitionRange;
	}
	
	public Boolean isTransactional() {
		return this.transactional;
	}
	
	public String getDeltaComparison() {
		return this.deltaComparison;
	}
	
	public String getBucketComparison() {
		return this.bucketComparison;
	}
	
	public String getPartitionComparison() {
		return this.partitionComparison;
	}
	
	public Integer getSmallFileNumber() {
		return this.smallFileNumber;
	}
	
	public String getSmallFilePercent() {
		return this.smallFilePercent;
	}
	
	public List<Long> getDataFileSizes() {
		return this.allFileSizes;
	}
	
	public List<String> getPartitionNames() {
		return this.partitionNames;
	}
	
	public Map<String, Long> getFileNameAndSizeMap() {
		return this.fileNameAndSizeMap;
	}
	
	public Map<String, Integer> getDeltaMenuNumbers() {
		return this.deltaMenuNumbers;
	}
	
	public Map<String, Set<String>> getPartitionListMap() {
		return this.allPartitionListMap;
	}
}
