package io.transwarp.common.bean.table;

import java.util.ArrayList;
import java.util.List;

public class TextTableBean extends AbstractTable{

	private String fileComparison;
	
	private Integer smallFileNumber;
	private String smallFilePercent;
	
	private List<Long> dataFileSizes;
	
	public TextTableBean() {
		fileComparison = " | | |0";
		smallFileNumber = 0;
		smallFilePercent = "null";
		dataFileSizes = new ArrayList<Long>();
	}
	
	public void addDataFile(final Long fileSize) {
		this.dataFileSizes.add(fileSize);
	}
	
	public void setFileComparison(Object fileComparison) {
		this.fileComparison = fileComparison == null ? "0|0|0|0" : fileComparison.toString();
	}
	
	public void setSmallFileNumber(Object smallFileNumber) {
		this.smallFileNumber = smallFileNumber == null ? 0 : Integer.valueOf(smallFileNumber.toString());
	}
	
	public void setSmallFilePercent(Object smallFilePercent) {
		this.smallFilePercent = smallFilePercent == null ? "null" : smallFilePercent.toString();
	}
	
	public String getFileComparison() {
		return this.fileComparison;
	}
	
	public Integer getSmallFileNumber() {
		return this.smallFileNumber;
	}
	
	public String getSmallFilePercent() {
		return this.smallFilePercent;
	}
	
	public List<Long> getDataFileSizes() {
		return this.dataFileSizes;
	}
}
