package io.transwarp.common.util;

public abstract class AbstractRunnable implements Runnable {

	@Override
	public void run() {
		try {
			startCheck();
			MyThreadPool.threadSuccess();
		} catch (Exception e) {
			MyThreadPool.threadFailure();
			dealWithError(e);
		} finally {
			closeThread();
		}
		
	}
	
	public abstract void startCheck() throws Exception;
	public abstract void dealWithError(Exception e);
	public abstract void closeThread();

}
