package io.transwarp.common.util;

import io.transwarp.common.GlobalArgs;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecShell {
	
	private static Logger log = LoggerFactory.getLogger(ExecShell.class);
	
	private static String CMD_HEAD;
	private static String SCP_HEAD;
	private static String nodeUser;
	private static Long TIME_LIMIT;
	private static ExecutorService POOL;

	public static void init(String username, String rsa, String port) {
		ExecShell.nodeUser = username;
		ExecShell.CMD_HEAD = String.format("sudo ssh -p %s -o StrictHostKeyChecking=no -i %s %s@", port, rsa, username);
		ExecShell.SCP_HEAD = String.format("sudo scp -P %s -o StrictHostKeyChecking=no -i %s", port, rsa);
		ExecShell.POOL = Executors.newCachedThreadPool();
		ExecShell.TIME_LIMIT = 60000L;
	}
	
	public static String getKeytab(final String ipAddress, final String sid, final String keytab) {
		String savePath = GlobalArgs.goalPath + "serviceConfigs/keytab/";
		String keytabPath;
		if (GlobalArgs.version.startsWith("4")) {
			keytabPath = String.format("/etc/%s/", sid);
		} else {
			keytabPath = String.format("/etc/%s/conf/", sid);
		}
		try {
			UtilTools.buildDir(savePath);
			scpFileOfSudo(savePath, ipAddress, keytabPath, keytab);
			exec("sudo chmod 777 " + savePath + keytab);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return savePath + keytab;
	}

	public static void scpFileOfSudo(String localAddress, String foreignIP, String foreignAddress, String filename) {
		scpFileOfSudo(localAddress, foreignIP, foreignAddress, filename, "/tmp/inspection-temporary/");
	}
	
	public static void scpFileOfSudo(String localAddress, String foreignIP, String foreignAddress, String filename, String foreignTempDir) {
		if (!foreignAddress.endsWith("/")) {
			foreignAddress += "/";
		}
		exec(foreignIP, String.format("mkdir -p %s", foreignTempDir));
		exec(foreignIP, String.format("sudo cp %s%s %s", foreignAddress, filename, foreignTempDir));
		scpFile(String.format("%s@%s:%s%s", nodeUser, foreignIP, foreignTempDir, filename), localAddress);
	}
	
	public static void scpDir(String path1, String path2) {
		exec(String.format("%s -r %s %s", SCP_HEAD, path1, path2));
	}
	
	public static void scpFile(String path1, String path2) {
		exec(String.format("%s %s %s", SCP_HEAD, path1, path2));
	}
	
	public static String exec(String ipAddress, String cmd) {
		String execCmd = String.format("%s%s %s", CMD_HEAD, ipAddress, cmd);
		return exec(execCmd);
	}
	
	public static String exec(String cmd) {
		Process process = null;
		try {
			process = Runtime.getRuntime().exec(new String[]{"/bin/bash", "-c", cmd});
		} catch (IOException ioException) {
			ioException.printStackTrace();
		}
		if (process == null) {
			log.error("execute shell command faild, command is [{}]", cmd);
			return "";
		}
		Future<String> future = POOL.submit(new ShellCallable(process));
		String result = "";
		try {
			result = future.get(TIME_LIMIT, TimeUnit.MILLISECONDS);
		} catch (Exception e) {
			future.cancel(true);
			process.destroy();
			log.error("command [{}] execute is time out", cmd);
		}
		return result;
	}
	
/*	public static String getCmdOfSecurity(final boolean openKerberos, 
			final String keytabPath,
			final String hostname,
			final String cmd) {
		if(openKerberos) {
			if(Constant.version.startsWith("4")) {
				return String.format("kinit -kt %s hdfs/%s;%s", keytabPath, hostname, cmd);
			} else {
				return cmd;
			}
		} else {
			return "sudo -u hdfs " + cmd;
		}
	}*/
	
	public static void close() {
		POOL.shutdown();
	}
	
	public static String getNodeUser() {
		return ExecShell.nodeUser;
	}
	
	private ExecShell() {
	}
	
	private static class ShellCallable implements Callable<String> {
		
		private Process process;

		ShellCallable(Process process) {
			this.process = process;
		}
		
		@Override
		public String call() throws Exception {
			InputStream input = process.getInputStream();
			String result = getResult(input).trim();
			if (result.equals("")) {
				InputStream error = process.getErrorStream();
				String errorInfo = getResult(error);
				if (!errorInfo.equals("")) {
					log.error("shell command execute faild, error info is [{}]", errorInfo.trim());
				}
			}
			return result;
		}
		
		private String getResult(InputStream input) throws Exception {
			byte[] buffer = new byte[1024];
			StringBuffer answer = new StringBuffer();
			int len = -1;
			while (true) {
				len = input.read(buffer);
				if (len == -1) {
					break;
				}
				String str = new String(buffer, 0, len);
				answer.append(str);
			}
			return answer.toString();
		}
		
	}
}
