package io.transwarp.common.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public final class MyThreadPool {

	private static final Logger log = LoggerFactory.getLogger(MyThreadPool.class);
	
	private static ExecutorService threadPool;
	private static AtomicInteger successTask;
	private static AtomicInteger failureTask;
	private static AtomicInteger totalTask;
	
	public static void init(int threadNumber) {
		threadPool = Executors.newFixedThreadPool(threadNumber);
		successTask = new AtomicInteger(0);
		failureTask = new AtomicInteger(0);
		totalTask = new AtomicInteger(0);
	}
	
	public synchronized static void addNewThread(Runnable thread) {
		threadPool.execute(thread);
		totalTask.incrementAndGet();
	}
	
	public synchronized static void threadSuccess() {
		successTask.incrementAndGet();
	}
	
	public synchronized static void threadFailure() {
		failureTask.incrementAndGet();
	}
	
	public static void closeWhenAllCompleted(long waitTime, int countLimit) {
		while (true) {
			if (countLimit >= 0) {
				countLimit -= 1;
			}
			int surplusTask = totalTask.intValue() - (successTask.intValue() + failureTask.intValue());
			if (surplusTask == 0 || countLimit == 0) {
				break;
			}
			try {
				log.info(String.format("success task is %s, failure task is %s, surplus task is %s", successTask, failureTask, surplusTask));
				Thread.sleep(waitTime);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		int hasCompletedTask = successTask.intValue() + failureTask.intValue();
		if (hasCompletedTask < totalTask.intValue()) {
			log.info("there ars [{}] tasks are not completed", totalTask.intValue() - hasCompletedTask);
		} else {
			log.info(String.format("all task completed, success task number is %s, failure task number is %s", successTask, failureTask));
		}
		threadPool.shutdownNow();
	}
	
	private MyThreadPool() {
	}
}
