package io.transwarp.common.util;

import java.io.File;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.SSLContext;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AUTH;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.config.RequestConfig.Builder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.datanucleus.util.Base64;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class UploadReport {

	private static final int SOCKET_TIMEOUT = 10000;
	private static final int CONNECTION_REQUEST_TIMEOUT = 10000;
	private static final int CONNECTION_TIMEOUT = 10000;
	private CloseableHttpClient httpClient;
	private RequestConfig config;
	private String uploadUrl;
	private String uploadTGT;
	private boolean useProxy;
	private String proxyTGT;
	
	
	public static Build custom() {
		return new Build();
	}
	
	public String uploadFile(String filename) throws Exception {
		String uploadAction = getAction(uploadUrl);
		if (uploadAction.equals("")) {
			throw new Exception("upload file faild, get action is null");
		}
		FileBody fileBody = new FileBody(new File(filename));
		HttpEntity entity = MultipartEntityBuilder.create().addPart("file", fileBody).build();
		return execUpload(uploadUrl, uploadAction, entity, 1);
	}
	
	private String getAction(String url) throws Exception {
		System.out.println(url + "/upload");
		HttpGet httpget = new HttpGet(url + "/upload");
		httpget.setConfig(config);
		if (useProxy) {
			httpget.addHeader(AUTH.PROXY_AUTH_RESP, proxyTGT);
		}
		httpget.addHeader(AUTH.WWW_AUTH_RESP, uploadTGT);
		CloseableHttpResponse response = null;
		String result = "";
		try {
			response = httpClient.execute(httpget);
			result = EntityUtils.toString(response.getEntity());
			Document doc = Jsoup.parse(result);
			Element upload = doc.getElementById("form-upload");
			return upload.attr("action");
		} catch (Exception e) {
			System.out.println(result);
			e.printStackTrace();
		} finally {
			if(response != null) {
				response.close();
			}
		}
		return "";
	}
	
	private String execUpload(final String uploadUrl, final String uploadAction, HttpEntity entity, int index) throws Exception {
		HttpPost post = new HttpPost(uploadUrl + uploadAction);
		post.setConfig(config);
		post.setEntity(entity);
		if (useProxy) {
			post.addHeader(AUTH.PROXY_AUTH_RESP, proxyTGT);
		}
		post.addHeader(AUTH.WWW_AUTH_RESP, uploadTGT);
		CloseableHttpResponse response = null;
		String result = "";
		try {
			response = httpClient.execute(post);
			if (response.getStatusLine().getStatusCode() == 302 && index < 5) {
				String locationUrl = response.getLastHeader("Location").getValue();
				String newUrl = getUrl(locationUrl);
				response.close();
				return reUpload(newUrl, entity, index + 1);
			}
			result = response.getStatusLine().toString();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if(response != null) {
				response.close();
			}
		}
		return result;
	}
	
	private String getUrl(String locationUrl) throws Exception {
		URI uri = URI.create(locationUrl);
		URI effectiveURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), null, null, null);
		return effectiveURI.toString();
	}
	
	private String reUpload(String url, HttpEntity entity, int index) throws Exception {
		String uploadAction = getAction(url);
		if (uploadAction.equals("")) {
			throw new Exception("reUpload file faild, get action is null");
		}
		return execUpload(url, uploadAction, entity, index);
	}
	
	private UploadReport(final String protocol, final HttpHost proxy) {
		this.httpClient = getHttpClient(protocol);
		this.config = getRequestConfig(proxy);
	}
	
	private CloseableHttpClient getHttpClient(String protocol) {
		HttpClientBuilder builder = HttpClients.custom();
		try {
			SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy() {
					@Override
					public boolean isTrusted(X509Certificate[] chain,
							String authType) throws CertificateException {
						return true;
					}
				}).build();
			SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext);
			builder.setSSLSocketFactory(sslsf);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return builder.build();
	}
	
	private RequestConfig getRequestConfig(final HttpHost proxy) {
		Builder builder = RequestConfig.custom()
			.setSocketTimeout(SOCKET_TIMEOUT)
			.setConnectionRequestTimeout(CONNECTION_REQUEST_TIMEOUT)
			.setConnectTimeout(CONNECTION_TIMEOUT);
		if (proxy != null) {
			builder = builder.setProxy(proxy);
		}
		return builder.build();
	}
	
	public static class Build {
		
		private String uploadProcotol;
		private String uploadUrl;
		private String uploadUsername;
		private String uploadPassword;
		
		private String proxyIP;
		private int proxyPort;
		private String proxyUsername;
		private String proxyPassword;
		
		Build() {
			uploadUrl = "";
			uploadUsername = "";
			uploadPassword = "";
			proxyIP = "";
			proxyPort = 80;
			proxyUsername = "";
			proxyPassword = "";
		}
		
		public UploadReport build() {
			if (uploadUrl.equals("")) {
				return null;
			}
			HttpHost proxy = null;
			if (!"".equals(proxyIP)) {
				proxy = new HttpHost(proxyIP, proxyPort);
			}
			if (uploadUrl.startsWith("https")) {
				uploadProcotol = "https";
			} else {
				uploadProcotol = "http";
			}
			UploadReport upload = new UploadReport(uploadProcotol, proxy);
			upload.uploadUrl = uploadUrl;
			upload.uploadTGT = "Basic " + Base64.encodeString(uploadUsername + ":" + uploadPassword);
			if (!"".equals(proxyIP)) {
				upload.useProxy = true;
				upload.proxyTGT = "Basic " + Base64.encodeString(proxyUsername + ":" + proxyPassword);
			} else {
				upload.useProxy = false;
			}
			return upload;
		}
		
		public Build setUploadUrl(Object uploadUrl) {
			this.uploadUrl = uploadUrl == null ? "" : uploadUrl.toString();
			return this;
		}
		
		public Build setUploadUsername(Object uploadUsername) {
			this.uploadUsername = uploadUsername == null ? "" : uploadUsername.toString();
			return this;
		}
		
		public Build setUploadPassword(Object uploadPassword) {
			this.uploadPassword = uploadPassword == null ? "" : uploadPassword.toString();
			return this;
		}
		
		public Build setProxyIP(Object proxyIP) {
			this.proxyIP = proxyIP == null ? "" : proxyIP.toString();
			return this;
		}
		
		public Build setProxyPort(Object proxyPort) {
			this.proxyPort = proxyPort == null ? 80 : Integer.valueOf(proxyPort.toString());
			return this;
		}
		
		public Build setProxyUsername(Object proxyUsername) {
			this.proxyUsername = proxyUsername == null ? "" : proxyUsername.toString();
			return this;
		}
		
		public Build setProxyPassword(Object proxyPassword) {
			this.proxyPassword = proxyPassword == null ? "" : proxyPassword.toString();
			return this;
		}
		
	}
	
	public static void main(String[] args) {
		UploadReport upload = UploadReport.custom()
			.setUploadUrl("http://polyactis.starcloud.io:10086")
			.setUploadUsername("yuhang")
			.setUploadPassword("Transwarp01!")
			.build();
		try {
			String result = upload.uploadFile("/home/xhy/temp/checkReport.xls");
			System.out.println(result);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
