package io.transwarp.common.util;

import java.io.File;
import java.io.FileOutputStream;

import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableWorkbook;

public final class WorkbookUtilTools {

	public static WritableWorkbook buildExcel(final String path) throws Exception {
		File file = new File(path);
		if (file.exists()) {
			file.delete();
		}
		return Workbook.createWorkbook(new FileOutputStream(file));
	}
	
	public static WritableCellFormat getCellFormat(final int fontSize,
			final String fontStype,
			final Alignment rowAlignment,
			final VerticalAlignment columnAlignment,
			final Colour fontColor,
			final Colour backgroundColor) {
		WritableCellFormat cell = null;
		try {
			WritableFont font = new WritableFont(WritableFont.ARIAL, fontSize);
			font.setColour(fontColor);
			if (fontStype.equals("BOLD")) {
				font.setBoldStyle(WritableFont.BOLD);
			}
			
			cell = new WritableCellFormat(font);
			cell.setBorder(Border.ALL, BorderLineStyle.THIN);
			cell.setAlignment(rowAlignment);
			cell.setVerticalAlignment(columnAlignment);
			if (backgroundColor != null) {
				cell.setBackground(backgroundColor);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return cell;
	}
	
	public static void close(WritableWorkbook workbook) {
		if (workbook == null) {
			return;
		}
		try {
			workbook.write();
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				workbook.close();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	private WorkbookUtilTools() {
	}
}
