package io.transwarp.hdfs.comparison;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.ClusterInfo;
import io.transwarp.report.comparison.Comparison;

public class HdfsComparisonImpl implements Comparison {

	private final ComparisonResultOfHdfs comparisonResult;
	private final ClusterInfo clusterInfo;
	private final String[] checkItems = new String[]{"reportAndFsck", "space"};
	
	public HdfsComparisonImpl(final ComparisonResultOfHdfs comparisonResult,
			final ClusterInfo clusterInfo) {
		this.comparisonResult = comparisonResult;
		this.clusterInfo = clusterInfo;
	}
	
	@Override
	public void comparison() throws Exception {
		Comparison comparison = null;
		for (String checkItem : checkItems) {
			comparison = buildComparison(checkItem);
			if (comparison != null) {
				try {
					comparison.comparison();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	private Comparison buildComparison(String checkItem) {
		if (checkItem.equals("reportAndFsck")) {
			return GlobalArgs.checkSelect.isHdfsInfo() ? new HdfsInfoComparisonImpl(comparisonResult, clusterInfo.getHdfsMetaDatas()) : null;
		} else if (checkItem.equals("space")) {
			return GlobalArgs.checkSelect.isHdfsSpace() ? new HdfsSpaceComparisonImpl(comparisonResult, clusterInfo.getHdfsSpace()) : null;
		}
		throw new RuntimeException("no find this check item : " + checkItem);
	}
}
