package io.transwarp.hdfs.comparison;

import io.transwarp.report.comparison.Comparison;

import java.util.Vector;

import net.sf.json.JSONObject;

public class HdfsSpaceComparisonImpl implements Comparison{
	
	private final ComparisonResultOfHdfs comparisonResult;
	private final Vector<JSONObject> hdfsSpaceInfo;

	public HdfsSpaceComparisonImpl(final ComparisonResultOfHdfs comparisonResult,
			Vector<JSONObject> hdfsSpaceInfo) {
		this.comparisonResult = comparisonResult;
		this.hdfsSpaceInfo = hdfsSpaceInfo;
	}
	
	@Override
	public void comparison() throws Exception {
		int size = hdfsSpaceInfo.size();
		sort(0, size - 1);
		for (JSONObject json : hdfsSpaceInfo) {
			String[] line = new String[4];
			line[0] = json.getString("path");
			line[1] = json.getString("totalSize");
			String smallFileNumber = json.getString("smallFileNumber");
			String totalFileNumber = json.getString("totalNumber");
			int numberOfSmallFile = Integer.valueOf(smallFileNumber);
			int numberOfTotalFile = Integer.valueOf(totalFileNumber);
			line[2] = smallFileNumber;
			line[3] = String.format("%.2f %%", numberOfSmallFile*100.0/numberOfTotalFile);
			comparisonResult.hdfsSpace.add(line);	
		}
	}
	
	
	private void sort(final int left, final int right) {
		if (left >= right) {
			return;
		}
		int mid = (left + right)/2;
		sort(left, mid);
		sort(mid + 1, right);
		merge(left, mid, right);
	}
	
	private void merge(final int left, final int mid, final int right) {
		JSONObject[] temp = new JSONObject[right - left + 1];
		int leftId = left;
		int rightId = mid + 1;
		int tempId = 0;
		while (leftId <= mid && rightId <= right) {
			JSONObject json1 = hdfsSpaceInfo.get(leftId);
			JSONObject json2 = hdfsSpaceInfo.get(rightId);
			if (compare(json1, json2)) {
				temp[tempId++] = json1;
				leftId += 1;
			} else {
				temp[tempId++] = json2;
				rightId += 1;
			}
		}
		
		while (leftId <= mid) {
			temp[tempId++] = hdfsSpaceInfo.get(leftId++);
		}
		
		while (rightId <= right) {
			temp[tempId++] = hdfsSpaceInfo.get(rightId++);
		}
		
		for (int i = left; i <= right; i++) {
			hdfsSpaceInfo.set(i, temp[i - left]);
		}
	}
	
	private Boolean compare(JSONObject json1, JSONObject json2) {
		int smallFileNumber1 = json1.getInt("smallFileNumber");
		int smallFileNumber2 = json2.getInt("smallFileNumber");
		if (smallFileNumber1 > smallFileNumber2) {
			return true;
		} else {
			return false;
		}
	}
}
