package io.transwarp.hdfs.report;

import java.util.Map;

import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class HdfsInfoXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final Map<String, String> hdfsMetaData;
	
	public HdfsInfoXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final Map<String, String> hdfsMetaData) {
		this.sheet = workbook.createSheet("hdfsInfo", checkItem.ordinal());
		this.hdfsMetaData = hdfsMetaData;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		beginRow = writeReportInfo(beginRow, hdfsMetaData.get("report").split("\n"));
		beginRow = writeFsckInfo(beginRow, hdfsMetaData.get("fsck").split("\n"));
		setCellSize();
	}
	
	private int writeReportInfo(int beginRow, String[] reportInfo) throws Exception {
		sheet.addCell(new Label(0, beginRow++, "report", CELL_BOLD));
		
		for (String line : reportInfo) {
			line = line.replaceAll("\t", " ").trim();
			if (line.startsWith("DFS Used%")) {
				addCellWithFormat(1, beginRow, line, CELL_EMPHASIS);
			} else {
				addCellWithFormat(1, beginRow, line, CELL_THIN);
			}
			beginRow += 1;
		}
		return beginRow;
	}
	
	private int writeFsckInfo(int beginRow, String[] fsckInfo) throws Exception {
		sheet.addCell(new Label(0, beginRow++, "fsck", CELL_BOLD));
		int totalLines = fsckInfo.length;
		int beginId = 0;
		for (int i = 0; i < totalLines; i++) {
			if (fsckInfo[i].indexOf(".Status") != -1) {
				beginId = i;
				break;
			}
		}
		
		for (int i = beginId; i < totalLines; i++) {
			String line = fsckInfo[i].replaceAll("\t", " ").trim();
			addCellWithFormat(1, beginRow++, line, CELL_THIN);
		}
		if (beginId > 40000) {
			beginId = 40000;
		}
		for (int i = 0; i < beginId; i++) {
			String line = fsckInfo[i].replaceAll("\t", " ");
			if (line.startsWith(".") && line.endsWith(".")) {
				continue;
			}
			addCellWithFormat(1, beginRow++, line, CELL_THIN);
		}
		return beginRow;
	}
	
	private void addCellWithFormat(final int column, 
			final int row, 
			final String lineValue, 
			final WritableCellFormat format) throws Exception {
		int splitId = lineValue.indexOf(": ");
		if (splitId == -1) {
			sheet.mergeCells(column, row, column + 1, row);
			sheet.addCell(new Label(column, row, lineValue, format));
		} else {
			String key = lineValue.substring(0, splitId);
			String value = lineValue.substring(splitId + 1);
			sheet.addCell(new Label(column, row, key, format));
			sheet.addCell(new Label(column + 1, row, value, format));
		}
	}
	
	private void setCellSize() {
		sheet.setColumnView(0, 15);
		sheet.setColumnView(1, 40);
		sheet.setColumnView(2, 40);
	}
}
