package io.transwarp.hdfs.report;

import java.util.List;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class HdfsSpaceXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final List<String[]> result;
	
	public HdfsSpaceXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final List<String[]> result) {
		this.sheet = workbook.createSheet("hdfs space", checkItem.ordinal());
		this.result = result;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		beginRow = writeTitle(beginRow);
		beginRow = writeHdfsSpaceInfo(beginRow);
		setColumnSize();
	}
	
	private int writeTitle(int beginRow) throws Exception {
		sheet.mergeCells(0, beginRow, 4, beginRow);
		sheet.addCell(new Label(0, beginRow++, "hdfs目录大小和小文件个数检查[不包括表的数据空间]", CELL_BOLD));
		sheet.addCell(new Label(1, beginRow, "hdfs path", CELL_BOLD));
		sheet.addCell(new Label(2, beginRow, "menu size", CELL_BOLD));
		sheet.addCell(new Label(3, beginRow, "small file number", CELL_BOLD));
		sheet.addCell(new Label(4, beginRow, "small file number perison", CELL_BOLD));
		return beginRow + 1;
		
	}
	
	private int writeHdfsSpaceInfo(int beginRow) throws Exception {
		for (String[] line : result) {
			for (int i = 0; i < 4; i++) {
				sheet.addCell(new Label(i + 1, beginRow, line[i], CELL_THIN));
			}
			beginRow += 1;
		}
		return beginRow;
	}
	
	private void setColumnSize() {
		sheet.setColumnView(1, 15);
		sheet.setColumnView(2, 15);
		sheet.setColumnView(3, 30);
		sheet.setColumnView(4, 30);
	}
}
