package io.transwarp.hdfs.servlet;

import java.util.List;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.ClusterInfo;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.bean.service.ConfigBean;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.util.ExecShell;
import io.transwarp.common.util.HdfsConnUtils;
import io.transwarp.common.util.MyThreadPool;
import io.transwarp.inspection.CheckInterface;

public class HdfsCheck implements CheckInterface {

	private final ClusterInfo clusterInfo;
	private final ServiceBean service;
	private final HdfsConnUtils hdfsPool;
	
	public HdfsCheck(final ClusterInfo clusterInfo,
			final ServiceBean service) {
		this.clusterInfo = clusterInfo;
		this.service = service;
		this.hdfsPool = GlobalArgs.hdfsPools.get(service.getName());
	}
	
	@Override
	public void check() throws Exception {
		openHdfsConnection();
		if (!hdfsPool.isBuildPoolSuccess()) {
			throw new Exception("open hdfs connection faild");
		}
		if (GlobalArgs.checkSelect.isHdfsInfo()) {
			MyThreadPool.addNewThread(new HdfsCheckRunnable(hdfsPool, clusterInfo, service.getSid(), service.getEnableKerberos().equals("true") ? true : false));
		}
		if (GlobalArgs.checkSelect.isHdfsSpace()) {
			MyThreadPool.addNewThread(new HdfsSpaceCheckRunnable(hdfsPool, clusterInfo));
		}
	}
	
	private void openHdfsConnection() {
		String sid = service.getSid();
		String namenodeIPAndHost = getNamenodeIPAndHost();
		if (namenodeIPAndHost == null) {
			namenodeIPAndHost = String.format("%s|%s", GlobalArgs.managerIP, GlobalArgs.managerHost);
		}
		String[] ipAndHost = namenodeIPAndHost.split("\\|");
		String keytabPath = ExecShell.getKeytab(ipAndHost[0], sid, "hdfs.keytab");
		boolean openKerberos = service.getEnableKerberos().equals("true") ? true : false;
		ConfigBean config = null;
		int count = 0;
		while (config == null) {
			config = service.getConfig();
			count += 1;
			if (count > 60) {
				break;
			}
			try {
				System.out.println("wait hdfs config check completed");
				Thread.sleep(1000);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		boolean buildHdfsConnPool = hdfsPool.openHdfsConnPool(openKerberos, 
				ipAndHost[1], 
				config, 
				ipAndHost[0],
				keytabPath, 
				GlobalArgs.threadNumber);
		
		StringBuffer info = new StringBuffer();
		info.append("open hdfs connected result is : ").append(buildHdfsConnPool).append("\n");
		info.append("##########  open hdfs connected info  ##########").append("\n")
			.append("service name is : ").append(service.getName()).append("\n")
			.append("enable kerberos : ").append(openKerberos).append("\n");
		if (openKerberos) {
			info.append("hdfs keytab path : ").append(keytabPath).append("\n");
		}
		info.append("################################################");
		System.out.println(info.toString());
	}
	
	private String getNamenodeIPAndHost() {
		List<RoleBean> roles = service.getRoles();
		for (RoleBean role : roles) {
			String type = role.getRoleType();
			if (type.matches("\\S*NAMENODE\\S*")) {
				NodeBean node = role.getNode();
				return String.format("%s|%s", node.getIpAddress(), node.getHostName());
			}
		}
		return null;
	}
}
