package io.transwarp.hdfs.servlet;

import java.util.List;

import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.ClusterInfo;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.common.util.HdfsConnUtils;
import io.transwarp.inspection.CheckItemEnum;

public class HdfsCheckRunnable extends AbstractRunnable {
	
	private final Logger log = LoggerFactory.getLogger(HdfsCheckRunnable.class);
	private final ClusterInfo clusterInfo;
	private final String namenodeIP;
	private final String namenodeHost;
	private final String sid;
	private final boolean openKerberos;

	public HdfsCheckRunnable(final HdfsConnUtils hdfsPool,
			final ClusterInfo clusterInfo,
			final String sid,
			final boolean openKerberos) {
		this.clusterInfo = clusterInfo;
		this.sid = sid;
		this.openKerberos = openKerberos;
		this.namenodeIP = hdfsPool.getNamenodeIP();
		this.namenodeHost = hdfsPool.getNamenodeHost();
	}

	@Override
	public void startCheck() throws Exception {
		log.info("begin check hdfs report/fsck");
		List<Element> configs = clusterInfo.prop_hdfs_check.getAll();
		if (GlobalArgs.version.startsWith("4")) {
			checkHdfsBy4X(configs);
		} else {
			checkHdfsBy5X(configs);
		}		
	}

	@Override
	public void dealWithError(Exception e) {
		GlobalArgs.ERROR_INFO.add(String.format("hdfs report/fsck check faild | " + e.getMessage()));
		e.printStackTrace();		
	}

	@Override
	public void closeThread() {
		log.info("hdfs report/fsck check completed");
		GlobalArgs.timeStatisticses.get(CheckItemEnum.SERVICE.name()).setEndTime();
	}
	
	private void checkHdfsBy4X(List<Element> configs) throws Exception {
		if(openKerberos) {
			ExecShell.exec(namenodeIP, "mkdir -p /tmp/inspection-temporary/");
			String scpKeytabCmd = String.format("sudo scp /etc/%s/hdfs.keytab /tmp/inspection-temporary/", sid);
			ExecShell.exec(namenodeIP, scpKeytabCmd);
		}
		for(Element config : configs) {
			String name = config.elementText("name");
			String command = config.elementText("value");
			String result = "";
			if(openKerberos) {
				ExecShell.exec(namenodeIP, String.format("kinit -kt /tmp/inspection-temporary/hdfs.keytab hdfs/%s", namenodeHost));
				result = ExecShell.exec(namenodeIP, command);
				
			} else {
				command = String.format("sudo -u hdfs %s", command);
				result = ExecShell.exec(namenodeIP, command);
			}
			clusterInfo.addHdfsMetaData(name, result);
		}
	}
	
	private void checkHdfsBy5X(List<Element> configs) throws Exception {
		String dockerID = getDockerID();
		if(openKerberos) {
			kinitHdfsUser(dockerID);
		}
		for(Element config : configs) {
			String name = config.elementText("name");
			String command = config.elementText("value");
			if(openKerberos) {
				command = String.format("sudo docker exec %s %s", dockerID, command);
			} else {
				command = String.format("sudo docker exec %s sudo -u hdfs %s", dockerID, command);
			}
			String result = ExecShell.exec(namenodeIP, command);
			clusterInfo.addHdfsMetaData(name, result);
		}
	}
	
	private void kinitHdfsUser(String dockerID) {
		ExecShell.exec(namenodeIP, String.format("sudo docker exec %s mkdir -p /tmp/inspection-temporary/", dockerID));
		String scpKeytab = String.format("sudo docker exec %s sudo scp /etc/%s/conf/hdfs.keytab /tmp/inspection-temporary/", dockerID, sid);
		ExecShell.exec(namenodeIP, scpKeytab);
		String kinitCmd = String.format("sudo docker exec %s kinit -kt /tmp/inspection-temporary/hdfs.keytab hdfs/%s", dockerID, namenodeHost);
		ExecShell.exec(namenodeIP, kinitCmd);
	}
	
	private String getDockerID() {
		try {
			String result = ExecShell.exec(namenodeIP, "sudo docker ps | grep HDFS_NAMENOD | awk '{print $1}'");
			return result.trim();
		} catch(Exception e) {
			e.printStackTrace();
			return "";
		}
	}
}
