package io.transwarp.node.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.UtilTools;
import io.transwarp.report.comparison.Comparison;

public class DiskUsedComparisonImpl implements Comparison {
	
	private final Map<String, NodeBean> nodes;
	private final ComparisonResultOfNode comparisonResult;
	
	public DiskUsedComparisonImpl(final ComparisonResultOfNode comparisonResult,
			final Map<String, NodeBean> nodes) {
		this.nodes = nodes;
		this.comparisonResult = comparisonResult;
	}

	@Override
	public void comparison() throws Exception {
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			String ipAddress = node.getIpAddress();
			
			String[] diskInfos = node.getParamFromShell("disk").split("\n");
			List<String[]> resultOfDisk = new ArrayList<String[]>();
			Double diskUsedLimit = Double.valueOf(GlobalArgs.prop_rules.getProperty("node.disk.used.limit", "75"));
			boolean diskWarn = analysis(resultOfDisk, diskInfos, diskUsedLimit);
			comparisonResult.diskUsed.put(ipAddress, resultOfDisk);
			comparisonResult.diskUsedWarn.put(ipAddress, diskWarn);
			
			String[] inodeInfos = node.getParamFromShell("inode").split("\n");
			List<String[]> resultOfInode = new ArrayList<String[]>();
			Double inodeUsedLimit = Double.valueOf(GlobalArgs.prop_rules.getProperty("node.inode.used.limit", "75"));
			boolean inodeWarn = analysis(resultOfInode, inodeInfos, inodeUsedLimit);
			comparisonResult.inodeUsed.put(ipAddress, resultOfInode);
			comparisonResult.inodeUsedWarn.put(ipAddress, inodeWarn);
		}
	}
	
	private boolean analysis(final List<String[]> result, String[] lines, double usedLimit) throws Exception {
		boolean warn = false;
		for (String line : lines) {
			String[] items = line.split("\\s+");
			result.add(items);
			if (items.length > 5) {
				try {
					Double usedPercent = Double.valueOf(UtilTools.numberFormat(items[4]));
					if (usedPercent > usedLimit) {
						warn = true;
					}
				} catch (NumberFormatException numberException) {
					continue;
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		return warn;
	}
}
