package io.transwarp.node.comparison;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeSet;

import org.dom4j.Element;

import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.node.MetricBean;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.comparison.Comparison;


public class MetricComparisonImpl implements Comparison {

	private final ComparisonResultOfNode comparisonResult;
	private final Map<String, NodeBean> nodes;
	private final ReadXmlUtil prop_metric;
	
	public MetricComparisonImpl(final ComparisonResultOfNode comparisonResult,
			final Map<String, NodeBean> nodes,
			final ReadXmlUtil prop_metric) {
		this.comparisonResult = comparisonResult;
		this.nodes = nodes;
		this.prop_metric = prop_metric;
	}
	
	@Override
	public void comparison() throws Exception {
		List<Element> configs = prop_metric.getAll();
		for (Element config : configs) {
			String metricNameCN = config.elementText("name");
			analysisMetric(metricNameCN, false);
//			analysisMetric(metricNameCN, true);
		}
	}
	
	private void analysisMetric(final String metricNameCN, final Boolean isDetail) {
		Map<Long, List<String>> result = new HashMap<Long, List<String>>(); 
		List<String> title = new ArrayList<String>();
		title.add("timestamp");
		result.put(0L, title);
		Set<Long> timeSet = getTimeSet(metricNameCN, isDetail);
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			MetricBean metric = node.getMetricByName(metricNameCN, isDetail);
			title.add(String.format("%s[%s]", node.getHostName(), metric.getUnit()));
			Map<Long, String> metricValues = metric.getMetricValues();
			for (Long timeStamp : timeSet) {
				String value = metricValues.get(timeStamp);
				value = value == null ? "" : value;
				List<String> line = result.get(timeStamp);
				if (line == null) {
					line = new ArrayList<String>();
					line.add(String.valueOf(timeStamp));
					result.put(timeStamp, line);
				}
				line.add(value);
			}
		}
		addResultToComparisonResult(metricNameCN, result, timeSet, isDetail);
	}
	
	private void addResultToComparisonResult(final String metricNameCN, 
			final Map<Long, List<String>> result,
			final Set<Long> timeSet,
			final Boolean isDetail) {
		List<String[]> lines = new ArrayList<String[]>();
		List<String> title = result.get(0L);
		lines.add(title.toArray(new String[title.size()]));
		for (Long timeStamp : timeSet) {
			List<String> line = result.get(timeStamp);
			if (line != null) {
				lines.add(line.toArray(new String[line.size()]));
			}
		}
		if (isDetail) {
			comparisonResult.metricInDetail.put(metricNameCN, lines);
		} else {
			comparisonResult.metricOneDay.put(metricNameCN, lines);
		}
	}
	
	private Set<Long> getTimeSet(final String metricNameCN, final Boolean isDetail) {
		Set<Long> timeSet = new TreeSet<Long>();
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			MetricBean metric = node.getMetricByName(metricNameCN, isDetail);
			Map<Long, String> metricValues = metric.getMetricValues();
			timeSet.addAll(metricValues.keySet());
		}
		return timeSet;
	}
}
