package io.transwarp.node.comparison;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.NodeInfo;
import io.transwarp.report.comparison.Comparison;

public class NodeComparisonImpl implements Comparison {

	private final ComparisonResultOfNode comparisonResultOfNode;
	private final NodeInfo nodeInfo;
	private final ReadXmlUtil prop_metric;
	private final String[] checkItems = new String[]{"disk", "port", "metric"};
	
	public NodeComparisonImpl(final ComparisonResultOfNode comparisonResultOfNode,
			final NodeInfo nodeInfo,
			final ReadXmlUtil prop_metric) {
		this.comparisonResultOfNode = comparisonResultOfNode;
		this.nodeInfo = nodeInfo;
		this.prop_metric = prop_metric;
	}
	
	@Override
	public void comparison() throws Exception {
		Comparison comparison = null;
		for (String checkItem : checkItems) {
			comparison = buildComparison(checkItem);
			if (comparison != null) {
				try {
					comparison.comparison();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	private Comparison buildComparison(String checkItem) {
		if (checkItem.equals("disk")) {
			return GlobalArgs.checkSelect.isNodeCheck() ? new DiskUsedComparisonImpl(comparisonResultOfNode, nodeInfo.getNodes()) : null;
		} else if (checkItem.equals("port")) {
			return GlobalArgs.checkSelect.isNodeCheck() ? new PortComparisonImpl(comparisonResultOfNode, nodeInfo) : null;
		} else if (checkItem.equals("metric")) {
			return new MetricComparisonImpl(comparisonResultOfNode, nodeInfo.getNodes(), prop_metric);
		}
		throw new RuntimeException("no find this check item : " + checkItem);
			
	}
}
