package io.transwarp.node.comparison;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.dom4j.Element;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.NodeInfo;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.comparison.Comparison;

public class PortComparisonImpl implements Comparison {

	private final ComparisonResultOfNode comparisonResult;
	private final NodeInfo nodeInfo;
	private final List<String> allPorts;
	
	public PortComparisonImpl(final ComparisonResultOfNode comparisonResult,
			final NodeInfo nodeInfo) {
		this.comparisonResult = comparisonResult;
		this.nodeInfo = nodeInfo;
		this.allPorts = new ArrayList<String>();
	}
	
	@Override
	public void comparison() throws Exception {
		getAllPorts();
		List<String[]> checkResult = new ArrayList<String[]>();
		String[] title = new String[allPorts.size() + 1];
		title[0] = "节点";
		for (int i = 0; i < allPorts.size(); i++) {
			title[i + 1] = allPorts.get(i);
		}
		checkResult.add(title);
		boolean warning = false;
		int portNumberLimit = Integer.valueOf(GlobalArgs.prop_rules.getProperty("node.port.number.limit", "300"));
		int number = allPorts.size();
		for (Entry<String, NodeBean> entry : nodeInfo.getNodes().entrySet()) {
			NodeBean node = entry.getValue();
			String[] nodePortInfo = new String[number + 1];
			int index = 0;
			nodePortInfo[index++] = node.getIpAddress();
			Map<String, String> portNumber = node.getPortNumber();
			for (String port : allPorts) {
				String temp = portNumber.get(port);
				if (temp != null && !temp.equals("")) {
					int connectedNumber = Integer.valueOf(temp);
					if (connectedNumber > portNumberLimit) {
						warning = true;
					}
				}
				nodePortInfo[index++] = temp;
			}
			checkResult.add(nodePortInfo);
		}
		comparisonResult.portConnectedNumber = checkResult;
		comparisonResult.portWarn = warning;
	}
	
	private void getAllPorts() {
		List<Element> configs = nodeInfo.prop_port_check.getAll();
		for (Element config : configs) {
			String[] ports = config.elementText("value").split(",");
			for (String port : ports) {
				allPorts.add(port);
			}
		}
	}
}
