package io.transwarp.node.report;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.node.comparison.ComparisonResultOfNode;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class DiskXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final ComparisonResultOfNode comparisonResult;
	private final Map<String, NodeBean> nodes;
	private int maxEndColumn;
	
	public DiskXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final Map<String, NodeBean> nodes,
			final ComparisonResultOfNode comparisonResult) {
		this.sheet = workbook.createSheet("disk", checkItem.ordinal());
		this.nodes = nodes;
		this.maxEndColumn = 0;
		this.comparisonResult = comparisonResult;
	}

	@Override
	public void writeSheet() throws Exception {
		int row = 0;
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			row = writeDiskOfNode(row, node) + 1;
		}
		// set cell size
		for (int i = 1; i < maxEndColumn; i++) {
			sheet.setColumnView(i, 15);
		}
	}
	
	private int writeDiskOfNode(int beginRow, final NodeBean node) throws Exception {
		sheet.addCell(new Label(0, beginRow++, node.getHostName(), CELL_THIN));
		int beginColumn = 1;
		String diskFailure = node.getDiskFailure();
		if (!diskFailure.equals("")) {
			sheet.addCell(new Label(beginColumn, beginRow, "disk failure : ", CELL_THIN));
			sheet.addCell(new Label(beginColumn + 1, beginRow, diskFailure, CELL_THIN));
			beginRow += 1;
		}
		//write inode info
		List<String[]> inodeInfo = comparisonResult.diskUsed.get(node.getIpAddress());
		beginColumn = writeInfo(beginColumn, beginRow, inodeInfo, "disk") + 1;
		
		//write disk info
		List<String[]> diskInfo = comparisonResult.inodeUsed.get(node.getIpAddress()); 
		beginColumn = writeInfo(beginColumn, beginRow, diskInfo, "inode") + 1;
		
		maxEndColumn = Math.max(beginColumn, maxEndColumn);
		return beginRow + Math.max(inodeInfo.size(), diskInfo.size()) + 1;
	}
	
	private int writeInfo(int beginColumn, int beginRow, final List<String[]> value, final String type) throws Exception {
		int endColumn = 0;
		for (String[] line : value) {
			int column = beginColumn;
			for (String item : line) {
				sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
			}
			beginRow += 1;
			endColumn = Math.max(endColumn, column);
		}
		return endColumn;
	}
	
}
