package io.transwarp.node.report;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.node.comparison.ComparisonResultOfNode;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class MetricXlsReportImpl implements XlsReport {
	
	private final ComparisonResultOfNode comparisonResult;
	private final WritableSheet sheet;
	private final SimpleDateFormat dateFormat;
	private int maxCol;
	
	public MetricXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final ComparisonResultOfNode comparisonResult) {
		this.comparisonResult = comparisonResult;
		this.sheet = workbook.createSheet("metric", checkItem.ordinal());
		this.maxCol = 0;
		this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		Map<String, List<String[]>> values = comparisonResult.metricOneDay;
		for (Entry<String, List<String[]>> entry : values.entrySet()) {
			String name = entry.getKey();
			List<String[]> lines = entry.getValue();
			beginRow = writeMetrics(beginRow, name, lines);
			
		}
		setColumnSize();
	}
	
	private int writeMetrics(int beginRow, final String name, final List<String[]> lines) throws Exception {
		sheet.addCell(new Label(0, beginRow++, name, CELL_BOLD));
		int rowNumber = lines.size();
		for (int i = 0; i < rowNumber; i++) {
			WritableCellFormat cell = i == 0 ? CELL_BOLD : CELL_THIN;
			String[] line = lines.get(i);
			int column = 1;
			int len = line.length;
			for (int j = 0; j < len; j++) {
				String item = (j == 0 && i > 0) ? dateFormat.format(Long.valueOf(line[j])) : line[j];
				sheet.addCell(new Label(column++, beginRow, item, cell));
			}
			beginRow += 1;
		}
		return beginRow + 1;
	}
	
	private void setColumnSize() {
		sheet.setColumnView(1, 30);
		for (int i = 2; i < maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
}
