package io.transwarp.node.report;

import java.util.Map;
import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.UtilTools;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class NodeXlsReportImpl implements XlsReport {
	
	private final Map<String, NodeBean> nodes;
	private final WritableSheet sheet;
	
	public NodeXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final Map<String, NodeBean> nodes) {
		this.sheet = workbook.createSheet("nodeInfo", checkItem.ordinal());
		this.nodes = nodes;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginColumn = 0;
		beginColumn = writeTitle(beginColumn);
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			beginColumn = writeNodeInfo(beginColumn, node);
		}
		for (int i = 0; i < beginColumn; i++) {
			sheet.setColumnView(i, 25);
		}
	}
	
	private int writeTitle(int beginColumn) throws Exception {
		int row = 0;
		sheet.addCell(new Label(beginColumn, row++, "节点地址:", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "rack name", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "hostname", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "ipAddress", CELL_BOLD));
		
		sheet.addCell(new Label(beginColumn, row++, "节点信息:", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "cluster name", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "total physics memory", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "cpu info", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.swappiness", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.min_free_kbytes", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.zone_reclaim_mode", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.vfs_cache_pressure", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.dirty_background_ratio", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "vm.dirty_ratio", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "huge page", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "DNS", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "iptables", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "timeZone", CELL_BOLD));
		
		sheet.addCell(new Label(beginColumn, row++, "NTP信息:", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "remote", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "refid", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "st", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "t", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "when", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "poll", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "reach", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "delay", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "offset", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "jitter", CELL_BOLD));
		
		sheet.addCell(new Label(beginColumn, row++, "服务状态", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "gmetad", CELL_BOLD));
		sheet.addCell(new Label(beginColumn + 1, row++, "gmond", CELL_BOLD));
		return beginColumn + 2;
	}
	
	private int writeNodeInfo(final int beginColumn, final NodeBean node) throws Exception {
		int row = 0;
		//根据节点上ntp服务的个数来确定列宽
		String ntpInfo = node.getParamFromShell("NTP");
		String[] linesOfNtp = ntpInfo.split("\n");
		int cellLen = linesOfNtp.length;
		
		row += 1;
		this.addSheetCell(beginColumn, row++, cellLen, node.getRackName());
		this.addSheetCell(beginColumn, row++, cellLen, node.getHostName());
		this.addSheetCell(beginColumn, row++, cellLen, node.getIpAddress());
		
		row += 1;
		this.addSheetCell(beginColumn, row++, cellLen, node.getClusterName());
		this.addSheetCell(beginColumn, row++, cellLen, UtilTools.getCarrySize(node.getTotalPhysMemBytes()));
		this.addSheetCell(beginColumn, row++, cellLen, node.getCpu());
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.swappiness"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.min_free_kbytes"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.zone_reclaim_mode"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.vfs_cache_pressure"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.dirty_background_ratio"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("vm.dirty_ratio"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("huge page"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("DNS"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("iptables"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getTimeZone());
		
		row += 1;
		//添加ntp信息
		if (cellLen > 0) {
			int buffer = row;
			for (int i = 1; i < cellLen; i++) {
				String[] items = linesOfNtp[i].split("\\s+");
				buffer = row;
				for (String item : items) {
					this.addSheetCell(beginColumn + i - 1, buffer++, 0, item);
				}
			}
			row = buffer;
		}
		
		row += 1;
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("gmetad"));
		this.addSheetCell(beginColumn, row++, cellLen, node.getParamFromShell("gmond"));
		
		return beginColumn + cellLen - 1;
	}
	
	private void addSheetCell(final int column, final int row, final int cellLen, final String value) throws Exception {
		if (cellLen > 2) {
			sheet.mergeCells(column, row, column + cellLen - 2, row);
		}
		sheet.addCell(new Label(column, row, value.trim(), CELL_THIN));
	}
}
