package io.transwarp.node.report;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.dom4j.Element;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.NodeInfo;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class PortXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final NodeInfo nodeInfo;
	private final List<String> allPorts;
	private int maxCol;
	
	public PortXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final NodeInfo nodeInfo) {
		this.sheet = workbook.createSheet("port", checkItem.ordinal());
		this.nodeInfo = nodeInfo;
		this.allPorts = new ArrayList<String>();
		this.maxCol = 0;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 1;
		int beginCol = 1;
		writeTitle(beginRow++, beginCol);
		
		for (Entry<String, NodeBean> entry : nodeInfo.getNodes().entrySet()) {
			NodeBean node = entry.getValue();
			int column = beginCol;
			Map<String, String> allPortNumber = node.getPortNumber();
			sheet.addCell(new Label(column++, beginRow, node.getIpAddress(), CELL_THIN));
			for (int i = 0; i < allPorts.size(); i++) {
				sheet.addCell(new Label(column++, beginRow, allPortNumber.get(allPorts.get(i)), CELL_THIN));
			}
			beginRow += 1;
		}
		for (int i = 1; i < maxCol; i++) {
			sheet.setColumnView(i, 25);
		}
	}
	
	private void writeTitle(final int beginRow, final int beginCol) throws Exception {
		int column = beginCol;
		sheet.addCell(new Label(column++, beginRow, "ipAddress", CELL_BOLD));
		List<Element> allConfigs = nodeInfo.prop_port_check.getAll();
		for (Element config : allConfigs) {
			String[] ports = config.elementText("value").split(",");
			for (String port : ports) {
				allPorts.add(port);
				sheet.addCell(new Label(column++, beginRow, String.format("端口号：%s", port), CELL_BOLD));
			}
		}
		this.maxCol = Math.max(column, maxCol);
	}

}
