package io.transwarp.node.servlet;

import java.util.Set;
import java.util.TreeSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;

public class DiskFailureCheckRunnable extends AbstractRunnable {
	
	private final static String CMD_CHECK_DISK = "dmesg | grep EXT4-fs | grep error";
	private final static String CMD_DISPLAY = "echo \"%s\" | awk -F\\( \'{print $2}\' | awk -F\\) \'{print \"#\"$1}\'";
	private final Logger log = LoggerFactory.getLogger(DiskFailureCheckRunnable.class);
	
	private final NodeBean node;
	
	public DiskFailureCheckRunnable(final NodeBean node) {
		this.node = node;
	}

	@Override
	public void startCheck() throws Exception {
		log.info("begin check node [{}] disk failure", node.getHostName());
		Set<String> result = checkDisk();
		if (result.size() > 0) {
			StringBuffer buf = new StringBuffer();
			boolean hasItem = false;
			for (String item : result) {
				if (hasItem) {
					buf.append(", ");
				}
				buf.append(item);
				hasItem = true;
			}
			node.setDiskFailure(buf.toString());
		}
	}

	@Override
	public void dealWithError(Exception e) {
		String errorInfo = String.format("check node disk failure in [%s] is faild, error message [%s]", node.getHostName(), e.getMessage());
		GlobalArgs.ERROR_INFO.add(errorInfo);
		log.error(errorInfo);
		e.printStackTrace();
	}

	@Override
	public void closeThread() {
		log.info("node [{}] disk failure check completed", node.getHostName());		
		GlobalArgs.timeStatisticses.get(CheckItemEnum.NODE.name()).setEndTime();
	}
	
	private Set<String> checkDisk() throws Exception {
		String ipAddress = node.getIpAddress();
		String result = ExecShell.exec(ipAddress, CMD_CHECK_DISK);
		if (result.equals("")) {
			return new TreeSet<String>();
		}
		Set<String> errorInfos = new TreeSet<String>();
		String[] lines = result.split("\n");
		for (String line : lines) {
			String cmd = String.format(CMD_DISPLAY, line);
			String errorInfo = ExecShell.exec(ipAddress, cmd);
			if (!errorInfo.equals("")) {
				errorInfos.add(errorInfo);
			}
		}
		return errorInfos;
	}
	
}
