package io.transwarp.node.servlet;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.NodeInfo;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.ExecShell;
import io.transwarp.common.util.MyThreadPool;
import io.transwarp.inspection.CheckInterface;

public class NodeCheck implements CheckInterface {
	
	private final Logger log = LoggerFactory.getLogger(NodeCheck.class);
	private final NodeInfo nodeInfo;
	
	public NodeCheck(final NodeInfo nodeInfo) {
		this.nodeInfo = nodeInfo;
	}

	@Override
	public void check() {
		String checkItems = nodeInfo.prop_node_check.getProperty("checkItem", "vm.swappiness,vm.min_free_kbytes,vm.zone_reclaim_mode,vm.vfs_cache_pressure,vm.dirty_background_ratio,vm.dirty_ratio,huge_page,NTP,JAVA_HOME,jdk_version,OSType,DNS,iptables,hosts,disk,inode,mount,gmetad,gmond");
		String[] items = checkItems.split(",");
		String agentProjectPath = "";
		if (GlobalArgs.configPath.startsWith("/etc/inspection")) {
			agentProjectPath = "/usr/lib/inspection/lib/inspectionAgent-1.0.jar";
		} else {
			agentProjectPath = "./lib/inspectionAgent-1.0.jar";
		}
		String jarPath = String.format("%sinspectionAgent-1.0.jar", GlobalArgs.temparoryPath);
		for (Entry<String, NodeBean> entry : nodeInfo.getNodes().entrySet()) {
			NodeBean node = entry.getValue();
			if (GlobalArgs.managerIP.equals(node.getIpAddress())) {
				GlobalArgs.managerHost = node.getHostName();
			}
			if (isConnectedBySsh(node.getIpAddress(), nodeInfo.getPort())) {
				sendAgentProjectToNode(agentProjectPath, jarPath, node.getIpAddress());
				MyThreadPool.addNewThread(new MysqlSynchronizedRunnable(node));
				if (GlobalArgs.checkSelect.isNodeCheck()) {
					MyThreadPool.addNewThread(new TimeZoneCheckRunnable(node, jarPath));
					MyThreadPool.addNewThread(new NodeCheckRunnable(node, items, nodeInfo.prop_node_check));
					MyThreadPool.addNewThread(new DiskFailureCheckRunnable(node));
					MyThreadPool.addNewThread(new PortCheckRunnable(node, nodeInfo.prop_port_check.getAll()));
				}
			} else {
				String errorMessage = String.format("check node info faild | could not connected to node [%s] of port %s", node.getHostName(), nodeInfo.getPort());
				GlobalArgs.ERROR_INFO.add(errorMessage);
				log.error(errorMessage);
			}
		}
	}
	
	
	private boolean isConnectedBySsh(String ipAddress, int port) {
		Socket socket = new Socket();
		try {
			socket.connect(new InetSocketAddress(ipAddress, port));
		} catch(Exception e) {
			e.printStackTrace();
			return false;
		} finally {
			try {
				socket.close();
			} catch(Exception e) {
				e.printStackTrace();
			}
		}
		return true;
	}
	
	private void sendAgentProjectToNode(String agentProjectPath, String savePath, String ipAddress) {
		try {
			ExecShell.exec(ipAddress, String.format("mkdir -p %s", GlobalArgs.temparoryPath));
			ExecShell.scpFile(agentProjectPath, String.format("%s@%s:%s", ExecShell.getNodeUser(), ipAddress, savePath));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
