package io.transwarp.node.servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;

public class NodeCheckRunnable extends AbstractRunnable {

	private final Logger log = LoggerFactory.getLogger(NodeCheckRunnable.class);
	private final NodeBean node;
	private final String[] checkItems;
	private final ReadXmlUtil prop_node_check;
	
	public NodeCheckRunnable(final NodeBean node,
			final String[] checkItems,
			final ReadXmlUtil prop_node_check) {
		this.node = node;
		this.checkItems = checkItems;
		this.prop_node_check = prop_node_check;
	}
	
	@Override
	public void startCheck() throws Exception {
		log.info("begin check system parameter of node [{}]", node.getHostName());
		String ipAddress = node.getIpAddress();
		for (String checkItem : checkItems) {
			String command = prop_node_check.getProperty(checkItem + ".command", "");
			if (command.equals("")) {
				log.warn("no find command of check : " + checkItem);
			} else {
				String result = ExecShell.exec(ipAddress, command);
				if (result.equals("")) {
					result = ExecShell.exec(ipAddress, String.format("sudo %s", command));
				}
				node.addParamByShell(checkItem, result);
			}
		}
	}
	
	@Override
	public void dealWithError(Exception e) {
		String errorMessage = String.format("system parameter check of node [%s] is faild | %s", node.getHostName(), e.getMessage());
		GlobalArgs.ERROR_INFO.add(errorMessage);
		log.error(errorMessage);
		e.printStackTrace();		
	}
	
	@Override
	public void closeThread() {
		log.info("system parameter check of node [{}] is completed", node.getHostName());
		GlobalArgs.timeStatisticses.get(CheckItemEnum.NODE.name()).setEndTime();
	}
}
