package io.transwarp.node.servlet;

import java.util.List;

import org.dom4j.Element;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;

public class PortCheckRunnable extends AbstractRunnable {
	
	private final static String command = "netstat -anp | grep ESTABLISHED | awk '{print $4}' | grep %s | wc -l";
	private final NodeBean node;
	private final List<Element> allPortChecks;
	
	public PortCheckRunnable(final NodeBean node,
			final List<Element> allPortChecks) {
		this.node = node;
		this.allPortChecks = allPortChecks;
	}
	
	@Override
	public void startCheck() throws Exception {
		String ipAddress = node.getIpAddress();
		for (Element config : allPortChecks) {
			String[] ports = config.elementText("value").split(",");
			for (String port : ports) {
				String queryCmd = String.format(command, port);
				String result = ExecShell.exec(ipAddress, queryCmd);
				node.addPortNumber(port, result);
			}
		}
	}
	
	@Override
	public void dealWithError(Exception e) {
		e.printStackTrace();		
	}

	@Override
	public void closeThread() {
		GlobalArgs.timeStatisticses.get(CheckItemEnum.NODE.name()).setEndTime();
	}
}
