package io.transwarp.node.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;

public class TimeZoneCheckRunnable extends AbstractRunnable {
	
	private final NodeBean node;
	private final String command;
	
	public TimeZoneCheckRunnable(NodeBean node, String jarPath) {
		this.node = node;
		this.command = String.format("java -cp %s io.transwarp.main.MainOfTimeZone", jarPath);
	}

	@Override
	public void startCheck() throws Exception {
		String result = ExecShell.exec(node.getIpAddress(), command);
		node.setTimeZone(result);		
	}

	@Override
	public void dealWithError(Exception e) {
		String msg = String.format("check node timeZone faild, message : %s", e.getMessage());
		GlobalArgs.ERROR_INFO.add(msg);
		e.printStackTrace();
	}

	@Override
	public void closeThread() {
		GlobalArgs.timeStatisticses.get(CheckItemEnum.NODE.name()).setEndTime();
	}

	
}
