package io.transwarp.report.html;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractContentItem {
	
	protected final List<String> result;
	protected Boolean warning;
	protected Integer risk;
	
	public AbstractContentItem() {
		result = new ArrayList<String>();
		warning = false;
		risk = 0;
	}

	public abstract void buildHtml(String itemName_EN, String itemName_CN);
	
	public List<String> getResult() {
		return result;
	}
	
	public Boolean isWarning() {
		if (warning == null) {
			warning = false;
		}
		return warning;
	}
	
	public Integer getRisk() {
		return risk;
	}
}
