package io.transwarp.report.html;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSummaryContent extends AbstractContentItem {
	
	private Integer successNumber;
	private Integer failureNumber;

	protected final InspectionData data;
	protected final ComparisonResult comparisonResult;
	protected List<String> checkItems;
	
	public AbstractSummaryContent(InspectionData data, ComparisonResult comparisonResult) {
		super();
		this.data = data;
		this.comparisonResult = comparisonResult;
		checkItems = new ArrayList<String>();
		successNumber = 0;
		failureNumber = 0;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		initCheckItems();
		result.add(String.format("<div id=\"%s\" class=\"titleStyle\"> <h2 class=\"checkItem\">%s</h2>\n", itemName_EN, itemName_CN));
		int number = checkItems.size();
		for (int i = 0; i < number; i++) {
			String itemName = checkItems.get(i);
			AbstractContentItem item = createItem(itemName);
			if (item != null) {
				try {
					item.buildHtml(String.format("%s%03d", itemName_EN, i), itemName);
				} catch (Exception e) {
					e.printStackTrace();
					continue;
				}
				List<String> resultOfItem = item.getResult();
				result.addAll(resultOfItem);
				if (item.isWarning()) {
					failureNumber += 1;
					risk += 1;
				} else {
					successNumber += 1;
				}
			}
		}
		result.add("</div>");
	}
	
	public abstract void initCheckItems();
	public abstract AbstractContentItem createItem(String itemName);
	
	public List<String> getCheckItems() {
		return checkItems;
	}
	
	public Integer getSuccessNumber() {
		return successNumber;
	}
	
	public Integer getFailureNumber() {
		return failureNumber;
	}
}
