package io.transwarp.report.html.baseEnv;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;
import io.transwarp.report.html.AbstractSummaryContent;
import io.transwarp.report.html.AbstractContentItem;

public class BaseEnvSummaryContentImpl extends AbstractSummaryContent {
	
	public BaseEnvSummaryContentImpl(InspectionData data, ComparisonResult comparisonResult) {
		super(data, comparisonResult);
	}

	@Override
	public void initCheckItems() {
		checkItems.add("操作系统版本号");
		checkItems.add("节点时区检查");
		checkItems.add("JDK版本号");
		checkItems.add("系统参数检查");
		checkItems.add("磁盘损坏检查");
		checkItems.add("CPU使用率检查");
		checkItems.add("内存使用率检查");
		checkItems.add("磁盘使用率检查");
		checkItems.add("网络发送速率检查");
		checkItems.add("网络接收速率检查");
	}

	@Override
	public AbstractContentItem createItem(String itemName) {
		if (itemName.equals("操作系统版本号")) {
			return new OSTypeContentItemImpl(data.nodeInfo.getNodes());
		} else if (itemName.equals("JDK版本号")) {
			return new JDKContentItemImpl(data.nodeInfo.getNodes());
		} else if (itemName.equals("系统参数检查")) {
			return new SystemParamContentItemImpl(data.nodeInfo.getNodes());
		} else if (itemName.equals("磁盘损坏检查")) {
			return new DiskFailureContentItemImpl(data.nodeInfo.getNodes());
		} else if (itemName.equals("CPU使用率检查")) {
			return new MetricContentItemImpl(data.nodeInfo.getNodes(), "cpu占用率");
		} else if (itemName.equals("内存使用率检查")) {
			return new MetricContentItemImpl(data.nodeInfo.getNodes(), "内存占用率");
		} else if (itemName.equals("磁盘使用率检查")) {
			return new MetricContentItemImpl(data.nodeInfo.getNodes(), "磁盘占用率");
		} else if (itemName.equals("网络发送速率检查")) {
			return new MetricContentItemImpl(data.nodeInfo.getNodes(), "网络发送速率");
		} else if (itemName.equals("网络接收速率检查")) {
			return new MetricContentItemImpl(data.nodeInfo.getNodes(), "网络接收速率");
		} else if (itemName.equals("节点时区检查")) {
			return new TimeZoneContentItemImpl(data.nodeInfo.getNodes());
		}
		throw new RuntimeException("no completed this item : " + itemName);
	}

}
