package io.transwarp.report.html.baseEnv;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.bean.node.MetricBean;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.html.AbstractContentItem;

public class MetricContentItemImpl extends AbstractContentItem {
	
	private final Map<String, NodeBean> nodes;
	private final String metricName;

	public MetricContentItemImpl(Map<String, NodeBean> nodes, String metricName_CN) {
		super();
		this.nodes = nodes;
		this.metricName = metricName_CN;
	}
	
	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"12%%\">节点</th> <th width=\"30%%\">时间范围</th> <th width=\"12%%\">指标名称</th> <th width=\"12%%\">最大值</th> <th width=\"12%%\">最小值</th> <th width=\"12%%\">平均值</th> </tr>\n");
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			String hostname = entry.getKey();
			NodeBean node = entry.getValue();
			MetricBean metric = node.getMetricByName(metricName, false);
			Map<Long, String> metricValue = metric.getMetricValues();
			int number = 0;
			Long maxTimestamp = 0L;
			Long minTimestamp = Long.MAX_VALUE;
			Double sumValue = 0.0;
			Double maxValue = 0.0;
			Double minValue = Double.MAX_VALUE;
			for (Entry<Long, String> valueEntry : metricValue.entrySet()) {
				number += 1;
				Long timestamp = valueEntry.getKey();
				Double value = Double.valueOf(valueEntry.getValue());
				maxTimestamp = Math.max(timestamp, maxTimestamp);
				minTimestamp = Math.min(timestamp, minTimestamp);
				maxValue = Math.max(value, maxValue);
				minValue = Math.min(value, minValue);
				sumValue += value;
			}
			if (minValue == Double.MAX_VALUE) {
				minValue = 0.0;
			}
			String unit = metric.getUnit();
			result.add(String.format("  <tr> <td width=\"12%%\">%s</td> <td width=\"30%%\">%s - %s</td> <td width=\"12%%\">%s</td> <td width=\"12%%\">%.2f %s</td> <td width=\"12%%\">%.2f %s</td> <td width=\"12%%\">%.2f %s</td> </tr>\n", hostname, dateFormat.format(minTimestamp),
					dateFormat.format(maxTimestamp), metricName, maxValue, unit, minValue, unit, sumValue/number, unit));
		}
		result.add("</table> </div>\n");
	}

}
