package io.transwarp.report.html.baseEnv;

import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.html.AbstractContentItem;

public class OSTypeContentItemImpl extends AbstractContentItem {
	
	private final Map<String, NodeBean> nodes;
	
	public OSTypeContentItemImpl(final Map<String, NodeBean> nodes) {
		super();
		this.nodes = nodes;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3>\n", itemName_EN, itemName_CN));
		result.add(String.format("  <table class=\"showtable\">\n"));
		result.add(String.format("    <tr> <th width=\"30%%\">节点</th> <th>操作系统</th> </tr>\n"));
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			result.add(String.format("    <tr> <td width=\"30%%\">%s</td> <td>%s</td> </tr>\n", node.getHostName(), node.getParamFromShell("OSType")));
		}
		result.add(String.format("  </table> </div> \n"));
	}

}
