package io.transwarp.report.html.baseEnv;

import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.html.AbstractContentItem;

public class SystemParamContentItemImpl extends AbstractContentItem {
	
	private final Map<String, NodeBean> nodes;

	public SystemParamContentItemImpl(final Map<String, NodeBean> nodes) {
		this.nodes = nodes;
	}
	
	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"11%%\">节点</th> <th width=\"11%%\">vm.swappiness</th> <th width=\"11%%\">vm.min_free_kbytes</th> "
				+ "<th width=\"11%%\">vm.zone_reclaim_mode</th> <th width=\"11%%\">vm.vfs_cache_pressure</th> <th width=\"11%%\">vm.dirty_background_ratio</th> "
				+ "<th width=\"11%%\">vm.dirty_ratio</th> <th width=\"11%%\">huge page</th> <th width=\"11%%\">DNS</th> </tr>\n");
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			result.add(String.format("  <tr> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> <td width=\"11%%\">%s</td> </tr>\n",
					node.getHostName(), node.getParamFromShell("vm.swappiness"), node.getParamFromShell("vm.min_free_kbytes"), 
					node.getParamFromShell("vm.zone_reclaim_mode"), node.getParamFromShell("vm.vfs_cache_pressure"),
					node.getParamFromShell("vm.dirty_background_ratio"), node.getParamFromShell("vm.dirty_ratio"), node.getParamFromShell("huge page"),
					node.getParamFromShell("DNS")));
		}
		result.add("</table> </div>\n");
	}

}
