package io.transwarp.report.html.baseEnv;

import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.report.html.AbstractContentItem;

public class TimeZoneContentItemImpl extends AbstractContentItem {

	private final Map<String, NodeBean> nodes;
	
	public TimeZoneContentItemImpl(final Map<String, NodeBean> nodes) {
		super();
		this.nodes = nodes;
	}
	
	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		String timeZone = null;
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"30%%\">节点</th> <th width=\"70%%\">节点时区</th> </tr>\n");
		for (Entry<String, NodeBean> entry : nodes.entrySet()) {
			NodeBean node = entry.getValue();
			if (timeZone != null && !timeZone.equals(node.getTimeZone())) {
				warning = true;
			}
			timeZone = node.getTimeZone();
			result.add(String.format("  <tr> <td width=\"30%%\">%s</td> <td width=\"70%%\">%s</td> </tr>\n", node.getHostName(), timeZone));
		}
		result.add("</table> </div>\n");
	}

}
