package io.transwarp.report.html.cluster;

import java.text.SimpleDateFormat;
import java.util.Vector;

import io.transwarp.common.bean.AlertBean;
import io.transwarp.report.html.AbstractContentItem;

public class AlertContentItemImpl extends AbstractContentItem {

	private final Vector<AlertBean> alerts;
	private final SimpleDateFormat dateFormat;
	
	public AlertContentItemImpl(Vector<AlertBean> alerts) {
		super();
		this.alerts = alerts;
		dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	}
	
	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"10%%\">时间</th> <th width=\"10%%\">标题</th> <th width=\"10%%\">级别</th> <th width=\"10%%\">分类</th> <th width=\"20%%\">涉及资源名</th> <th width=\"20%%\">涉及资源子项目</th> <th width=\"20%%\">描述</th> </tr>\n");
		for (AlertBean alert : alerts) {
			warning = true;
			risk += 1;
			result.add(String.format("  <tr> <td width=\"10%%\">%s</td> <td width=\"10%%\">%s</td> <td width=\"10%%\">%s</td> <td width=\"10%%\">%s</td> <td width=\"20%%\">%s</td> <td width=\"20%%\">%s</td> <td width=\"20%%\">%s</td> </tr>\n",
					dateFormat.format(Long.valueOf(alert.getTimeStamp())), alert.getTitle(), alert.getSeverity(), alert.getCategory(),
					alert.getContextName(), alert.getSubId(), alert.getDescription()));
		}
		if (alerts.size() == 0) {
			result.add("  <tr> <td colspan=\"7\">集群暂无告警信息</td> </tr>\n");
		}
		result.add(" </table> </div>\n");
	}
}
