package io.transwarp.report.html.cluster;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;
import io.transwarp.report.html.AbstractSummaryContent;
import io.transwarp.report.html.AbstractContentItem;

public class ClusterSummaryContentImpl extends AbstractSummaryContent {
	
	public ClusterSummaryContentImpl(InspectionData data, ComparisonResult comparisonResult) {
		super(data, comparisonResult);
	}

	@Override
	public void initCheckItems() {
		checkItems.add("集群告警信息");
		checkItems.add("端口连接数检查");
		checkItems.add("服务健康状态");
		checkItems.add("region server的region个数检查");
		checkItems.add("shard总大小检查");
	}

	@Override
	public AbstractContentItem createItem(String itemName) {
		if (itemName.equals("集群告警信息")) {
			return new AlertContentItemImpl(data.clusterInfo.getAlerts());
		} else if (itemName.equals("端口连接数检查")) {
			return new PortContentItemImpl(comparisonResult.NODE.portConnectedNumber, comparisonResult.NODE.portWarn);
		} else if (itemName.equals("服务健康状态")) {
			return new ServiceContentItemImpl(comparisonResult.CLUSTER.orderServices);
		} else if (itemName.equals("region server的region个数检查")) {
			return new RegionContentItemImpl(comparisonResult.TABLE.regionNumber);
		} else if (itemName.equals("shard总大小检查")) {
			return new ShardContentItemImpl(comparisonResult.TABLE.searchServices);
		}
		return null;
	}

}
