package io.transwarp.report.html.cluster;

import io.transwarp.report.html.AbstractContentItem;

import java.util.List;

public class PortContentItemImpl extends AbstractContentItem {

	private final List<String[]> ports;
	
	public PortContentItemImpl(List<String[]> ports, Boolean warning) {
		super();
		super.warning = warning;
		this.ports = ports;
		if (warning) {
			risk += 1;
		}
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		int number = ports.size();
		int width = 100/(number + 1);
		String widthString = String.format("width=\"%s%%\"", width);
		for (int i = 0; i < number; i++) {
			String itemType = i == 0 ? "th" : "td";
			String[] line = ports.get(i);
			StringBuffer buf = new StringBuffer();
			for (String item : line) {
				buf.append(String.format("<%s %s>%s</%s>\n", itemType, widthString, item, itemType));
			}
			result.add(String.format("  <tr>%s</tr>\n", buf.toString()));
		}
		result.add("</table> </div>\n");
	}

}
