package io.transwarp.report.html.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.report.html.AbstractContentItem;

public class RegionContentItemImpl extends AbstractContentItem {
	
	private final Map<String, Map<String, Integer>> regionNumbers;
	private final Map<String, Integer> totalRegion;
	private Integer limit;
	
	public RegionContentItemImpl(Map<String, Map<String, Integer>> regionNumbers) {
		super();
		this.regionNumbers = regionNumbers;
		totalRegion = new HashMap<String, Integer>();
		limit = Integer.valueOf(GlobalArgs.prop_rules.getProperty("table.hbase.region.totalNumber.limit", "1200"));
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		getTotalRegionNumber();
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"50%%\">节点</th> <th width=\"50%%\">总region个数</th> </tr>\n");
		for (Entry<String, Integer> entry : totalRegion.entrySet()) {
			String hostname = entry.getKey();
			Integer number = entry.getValue();
			result.add(String.format("  <tr> <td width=\"50%%\">%s</td> <td width=\"50%%\">%s</td> </tr>\n", hostname, number));
			if (number > limit) {
				warning = true;
				risk += 1;
			}
		}
		if (totalRegion.size() == 0) {
			result.add("  <tr> <td colspan=\"2\">暂时没有region信息</td> </tr>\n");
		}
		result.add("</table> </div> \n");
	}
	
	private void getTotalRegionNumber() {
		for (Entry<String, Map<String, Integer>> entry : regionNumbers.entrySet()) {
			Map<String, Integer> regionNumber = entry.getValue();
			for (Entry<String, Integer> numberEntry : regionNumber.entrySet()) {
				String hostname = numberEntry.getKey();
				Integer number = numberEntry.getValue();
				Integer value = totalRegion.get(hostname);
				if (value == null) {
					totalRegion.put(hostname, number);
				} else {
					totalRegion.put(hostname, number + value);
				}
			}
		}
	}
}
